/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.pug.impl;

import de.neuland.pug4j.PugConfiguration;
import de.neuland.pug4j.template.PugTemplate;
import de.neuland.pug4j.template.TemplateLoader;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.common.template.impl.TemplateHolder;
import io.vertx.ext.web.templ.pug.PugTemplateEngine;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class PugTemplateEngineImpl
extends CachingTemplateEngine<PugTemplate>
implements PugTemplateEngine {
    private final PugConfiguration config = new PugConfiguration();
    private final Charset encoding;

    public PugTemplateEngineImpl(Vertx vertx, String extension) {
        this(vertx, extension, StandardCharsets.UTF_8.name());
    }

    public PugTemplateEngineImpl(Vertx vertx, String extension, String encoding) {
        super(vertx, extension);
        this.config.setTemplateLoader((TemplateLoader)new PugTemplateLoader(vertx));
        this.config.setCaching(false);
        this.encoding = Charset.forName(encoding);
    }

    public <T> T unwrap() {
        return (T)this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<String, Object> context, String templateFile, Handler<AsyncResult<Buffer>> handler) {
        try {
            String src = this.adjustLocation(templateFile);
            TemplateHolder template = this.getTemplate(src);
            if (template == null) {
                PugTemplateEngineImpl pugTemplateEngineImpl = this;
                synchronized (pugTemplateEngineImpl) {
                    template = new TemplateHolder((Object)this.config.getTemplate(src));
                }
                this.putTemplate(src, template);
            }
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)this.config.renderTemplate((PugTemplate)template.template(), context))));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }

    private class PugTemplateLoader
    implements TemplateLoader {
        private final Vertx vertx;

        PugTemplateLoader(Vertx vertx) {
            this.vertx = vertx;
        }

        public long getLastModified(String name) throws IOException {
            name = PugTemplateEngineImpl.this.adjustLocation(name);
            try {
                if (this.vertx.fileSystem().existsBlocking(name)) {
                    return this.vertx.fileSystem().propsBlocking(name).lastModifiedTime();
                }
                throw new IOException("Cannot find resource " + name);
            }
            catch (RuntimeException e) {
                throw new IOException("Unexpected exception", e);
            }
        }

        public String getExtension() {
            return PugTemplateEngineImpl.this.extension;
        }

        public Reader getReader(String name) throws IOException {
            name = PugTemplateEngineImpl.this.adjustLocation(name);
            String templ = null;
            if (this.vertx.fileSystem().existsBlocking(name)) {
                templ = this.vertx.fileSystem().readFileBlocking(name).toString(PugTemplateEngineImpl.this.encoding);
            }
            if (templ == null) {
                throw new IOException("Cannot find resource " + name);
            }
            return new StringReader(templ);
        }

        public String getBase() {
            return "";
        }
    }
}

