/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.handlebars.impl;

import com.github.jknack.handlebars.ValueResolver;
import io.vertx.core.json.JsonArray;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

class JsonArrayValueResolver
implements ValueResolver {
    public static final ValueResolver INSTANCE = new JsonArrayValueResolver();

    JsonArrayValueResolver() {
    }

    public Object resolve(Object context) {
        if (context instanceof JsonArray) {
            return context;
        }
        return UNRESOLVED;
    }

    public Object resolve(Object context, String name) {
        if (context instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)context;
            if ("length".equals(name) || "size".equals(name)) {
                return jsonArray.size();
            }
            Object value = jsonArray.getValue(Integer.parseInt(name));
            if (value != null) {
                return value;
            }
        }
        return UNRESOLVED;
    }

    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        return Collections.emptySet();
    }
}

