/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.handlebars.impl;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.common.template.impl.TemplateHolder;
import io.vertx.ext.web.templ.handlebars.HandlebarsTemplateEngine;
import io.vertx.ext.web.templ.handlebars.impl.JsonArrayValueResolver;
import io.vertx.ext.web.templ.handlebars.impl.JsonObjectValueResolver;
import java.nio.charset.Charset;
import java.util.Map;

public class HandlebarsTemplateEngineImpl
extends CachingTemplateEngine<Template>
implements HandlebarsTemplateEngine {
    private final Handlebars handlebars;
    private final Loader loader;
    private ValueResolver[] resolvers;

    public HandlebarsTemplateEngineImpl(Vertx vertx, String extension) {
        super(vertx, extension);
        this.loader = new Loader(vertx);
        this.resolvers = new ValueResolver[ValueResolver.VALUE_RESOLVERS.length + 2];
        this.resolvers[0] = JsonArrayValueResolver.INSTANCE;
        this.resolvers[1] = JsonObjectValueResolver.INSTANCE;
        System.arraycopy(ValueResolver.VALUE_RESOLVERS, 0, this.resolvers, 2, ValueResolver.VALUE_RESOLVERS.length);
        this.handlebars = new Handlebars((TemplateLoader)this.loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<String, Object> context, String templateFile, Handler<AsyncResult<Buffer>> handler) {
        try {
            String src = this.adjustLocation(templateFile);
            TemplateHolder template = this.getTemplate(src);
            if (template == null) {
                int idx = src.lastIndexOf(47);
                String prefix = "";
                String basename = src;
                if (idx != -1) {
                    prefix = src.substring(0, idx);
                    basename = src.substring(idx + 1);
                }
                HandlebarsTemplateEngineImpl handlebarsTemplateEngineImpl = this;
                synchronized (handlebarsTemplateEngineImpl) {
                    this.loader.setPrefix(prefix);
                    template = new TemplateHolder((Object)this.handlebars.compile(basename), prefix);
                }
                this.putTemplate(src, template);
            }
            Context engineContext = Context.newBuilder(context).resolver(this.getResolvers()).build();
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)((Template)template.template()).apply(engineContext))));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }

    @Override
    public Handlebars getHandlebars() {
        return this.handlebars;
    }

    @Override
    public ValueResolver[] getResolvers() {
        return this.resolvers;
    }

    @Override
    public HandlebarsTemplateEngine setResolvers(ValueResolver ... resolvers) {
        this.resolvers = resolvers;
        return this;
    }

    private class Loader
    implements TemplateLoader {
        private final Vertx vertx;
        private String templateDirectory;
        private Charset charset = Charset.defaultCharset();

        Loader(Vertx vertx) {
            this.vertx = vertx;
        }

        public TemplateSource sourceAt(String location) {
            final String loc = this.resolve(location);
            final Buffer templ = this.vertx.fileSystem().existsBlocking(loc) ? this.vertx.fileSystem().readFileBlocking(loc) : null;
            if (templ == null) {
                throw new IllegalArgumentException("Cannot find resource " + loc);
            }
            final long lastMod = System.currentTimeMillis();
            return new TemplateSource(){

                public String content(Charset charset) {
                    return templ.toString(charset);
                }

                public String filename() {
                    return loc;
                }

                public long lastModified() {
                    return lastMod;
                }
            };
        }

        public String resolve(String location) {
            return this.templateDirectory + "/" + HandlebarsTemplateEngineImpl.this.adjustLocation(location);
        }

        public String getPrefix() {
            return this.templateDirectory;
        }

        public String getSuffix() {
            return HandlebarsTemplateEngineImpl.this.extension;
        }

        public void setPrefix(String prefix) {
            this.templateDirectory = prefix;
        }

        public void setSuffix(String suffix) {
            HandlebarsTemplateEngineImpl.this.extension = suffix;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public Charset getCharset() {
            return this.charset;
        }
    }
}

