/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.templ.FreeMarkerTemplateEngine;
import io.vertx.ext.web.templ.impl.CachingTemplateEngine;
import io.vertx.ext.web.templ.impl.FreeMarkerTemplateLoader;
import io.vertx.ext.web.templ.impl.VertxWebObjectWrapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;

public class FreeMarkerTemplateEngineImpl
extends CachingTemplateEngine<Template>
implements FreeMarkerTemplateEngine {
    private final Configuration config;
    private final FreeMarkerTemplateLoader loader = new FreeMarkerTemplateLoader();

    public FreeMarkerTemplateEngineImpl() {
        super("ftl", 10000);
        this.config = new Configuration(Configuration.VERSION_2_3_22);
        this.config.setObjectWrapper((ObjectWrapper)new VertxWebObjectWrapper(this.config.getIncompatibleImprovements()));
        this.config.setTemplateLoader((TemplateLoader)this.loader);
    }

    @Override
    public FreeMarkerTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public FreeMarkerTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RoutingContext context, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
        try {
            Template template = (Template)this.cache.get((Object)templateFileName);
            if (template == null) {
                FreeMarkerTemplateEngineImpl freeMarkerTemplateEngineImpl = this;
                synchronized (freeMarkerTemplateEngineImpl) {
                    this.loader.setVertx(context.vertx());
                    template = this.config.getTemplate(this.adjustLocation(templateFileName));
                }
                this.cache.put((Object)templateFileName, (Object)template);
            }
            HashMap<String, RoutingContext> variables = new HashMap<String, RoutingContext>(1);
            variables.put("context", context);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                template.process(variables, (Writer)new OutputStreamWriter(baos));
                handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((byte[])baos.toByteArray())));
            }
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }
}

