/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.cookie.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.sstore.AbstractSession;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class CookieSession
extends AbstractSession {
    private static final Base64.Encoder BASE64_URL_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder BASE64_URL_DECODER = Base64.getUrlDecoder();
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final Cipher encrypt;
    private final Cipher decrypt;
    private int oldVersion = 0;
    private int oldCrc = 0;

    public static String base64UrlEncode(byte[] bytes) {
        return BASE64_URL_ENCODER.encodeToString(bytes);
    }

    public static byte[] base64UrlDecode(String base64) {
        return BASE64_URL_DECODER.decode(base64);
    }

    public CookieSession(Cipher encrypt, Cipher decrypt, VertxContextPRNG prng, long timeout, int length) {
        super(prng, timeout, length);
        this.encrypt = encrypt;
        this.decrypt = decrypt;
    }

    public CookieSession(Cipher encrypt, Cipher decrypt, VertxContextPRNG prng) {
        super(prng);
        this.encrypt = encrypt;
        this.decrypt = decrypt;
    }

    public String value() {
        Buffer buff = Buffer.buffer();
        byte[] bytes = this.id().getBytes(UTF8);
        buff.appendInt(bytes.length).appendBytes(bytes);
        buff.appendLong(this.timeout());
        buff.appendLong(this.lastAccessed());
        buff.appendInt(this.version());
        this.writeDataToBuffer(buff);
        try {
            return CookieSession.base64UrlEncode(this.encrypt.doFinal(buff.getBytes()));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRegenerated() {
        if (!super.isRegenerated()) {
            return this.oldCrc != this.checksum();
        }
        return true;
    }

    protected CookieSession setValue(String payload) {
        if (payload == null) {
            throw new NullPointerException();
        }
        try {
            Buffer buffer = Buffer.buffer((byte[])this.decrypt.doFinal(CookieSession.base64UrlDecode(payload)));
            int pos = 0;
            int len = buffer.getInt(0);
            byte[] bytes = buffer.getBytes(pos += 4, pos + len);
            this.setId(new String(bytes, UTF8));
            this.setTimeout(buffer.getLong(pos += len));
            this.setLastAccessed(buffer.getLong(pos += 8));
            this.setVersion(buffer.getInt(pos += 8));
            this.readDataFromBuffer(pos += 4, buffer);
            this.oldVersion = this.version();
            this.oldCrc = this.crc();
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            return null;
        }
        return this;
    }

    int oldVersion() {
        return this.oldVersion;
    }
}

