/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.cookie.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.cookie.CookieSessionStore;
import io.vertx.ext.web.sstore.cookie.impl.CookieSession;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CookieSessionStoreImpl
implements CookieSessionStore {
    private Mac mac;
    private VertxContextPRNG random;

    public CookieSessionStoreImpl() {
    }

    public CookieSessionStoreImpl(Vertx vertx, String secret) {
        this.init(vertx, new JsonObject().put("secret", (Object)secret));
    }

    public SessionStore init(Vertx vertx, JsonObject options) {
        this.random = VertxContextPRNG.current((Vertx)vertx);
        try {
            this.mac = Mac.getInstance("HmacSHA256");
            this.mac.init(new SecretKeySpec(options.getString("secret").getBytes(), "HmacSHA256"));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public long retryTimeout() {
        return -1L;
    }

    public Session createSession(long timeout) {
        return new CookieSession(this.mac, this.random, timeout, 16);
    }

    public Session createSession(long timeout, int length) {
        return new CookieSession(this.mac, this.random, timeout, length);
    }

    public void get(String cookieValue, Handler<AsyncResult<@Nullable Session>> resultHandler) {
        try {
            CookieSession session = new CookieSession(this.mac, this.random).setValue(cookieValue);
            if (session == null) {
                resultHandler.handle((Object)Future.succeededFuture());
                return;
            }
            long now = System.currentTimeMillis();
            if (now - session.lastAccessed() > session.timeout()) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Object)session)));
            }
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void delete(String id, Handler<AsyncResult<Void>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture());
    }

    public void put(Session session, Handler<AsyncResult<Void>> resultHandler) {
        CookieSession cookieSession = (CookieSession)session;
        if (cookieSession.oldVersion() != -1 && cookieSession.oldVersion() != cookieSession.version()) {
            resultHandler.handle((Object)Future.failedFuture((String)"Version mismatch"));
            return;
        }
        cookieSession.incrementVersion();
        resultHandler.handle((Object)Future.succeededFuture());
    }

    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture());
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)0));
    }

    public void close() {
    }
}

