/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.graphql.impl;

import graphql.ExecutionInput;
import graphql.GraphQL;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext;
import io.vertx.ext.web.handler.graphql.GraphQLHandler;
import io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions;
import io.vertx.ext.web.handler.graphql.impl.GraphQLBatch;
import io.vertx.ext.web.handler.graphql.impl.GraphQLInput;
import io.vertx.ext.web.handler.graphql.impl.GraphQLQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;

public class GraphQLHandlerImpl
implements GraphQLHandler {
    private static final Pattern IS_NUMBER = Pattern.compile("\\d+");
    private final GraphQL graphQL;
    private final GraphQLHandlerOptions options;
    private final Handler<ExecutionInputBuilderWithContext<RoutingContext>> beforeExecuteHandler;

    public GraphQLHandlerImpl(GraphQL graphQL, GraphQLHandlerOptions options, Handler<ExecutionInputBuilderWithContext<RoutingContext>> beforeExecuteHandler) {
        this.graphQL = graphQL;
        this.options = options == null ? new GraphQLHandlerOptions() : options;
        this.beforeExecuteHandler = beforeExecuteHandler;
    }

    public void handle(RoutingContext rc) {
        HttpMethod method = rc.request().method();
        if (method == HttpMethod.GET) {
            this.handleGet(rc);
        } else if (method == HttpMethod.POST) {
            if (!rc.body().available()) {
                rc.fail(500, (Throwable)VertxException.noStackTrace((String)"BodyHandler is required to process POST requests"));
            } else {
                this.handlePost(rc, rc.body().buffer());
            }
        } else {
            rc.fail(405);
        }
    }

    private void handleGet(RoutingContext rc) {
        Map<String, Object> extensions;
        Object initialValue;
        Map<String, Object> variables;
        try {
            variables = this.getVariablesFromQueryParam(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        try {
            initialValue = this.getInitialValueFromQueryParam(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        try {
            extensions = this.getExtensionsFromQueryParam(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        String query = rc.queryParams().get("query");
        if (query == null) {
            if (extensions != null && extensions.containsKey("persistedQuery")) {
                query = "PersistedQueryMarker";
            } else {
                this.failQueryMissing(rc);
                return;
            }
        }
        GraphQLQuery graphQLQuery = new GraphQLQuery().setQuery(query).setOperationName(rc.queryParams().get("operationName")).setVariables(variables).setInitialValue(initialValue).setExtensions(extensions);
        this.executeOne(rc, graphQLQuery);
    }

    private void handlePost(RoutingContext rc, Buffer body) {
        Map<String, Object> extensions;
        Object initialValue;
        Map<String, Object> variables;
        try {
            variables = this.getVariablesFromQueryParam(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        try {
            initialValue = this.getInitialValueFromQueryParam(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        try {
            extensions = this.getExtensionsFromQueryParam(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        String query = rc.queryParams().get("query");
        if (query != null) {
            GraphQLQuery graphQLQuery = new GraphQLQuery().setQuery(query).setOperationName(rc.queryParams().get("operationName")).setVariables(variables).setInitialValue(initialValue).setExtensions(extensions);
            this.executeOne(rc, graphQLQuery);
            return;
        }
        switch (this.getContentType(rc)) {
            case "application/json": {
                if (body == null) {
                    rc.fail(400, (Throwable)VertxException.noStackTrace((String)"No body"));
                    return;
                }
                this.handlePostJson(rc, body, rc.queryParams().get("operationName"), variables, initialValue, extensions);
                break;
            }
            case "multipart/form-data": {
                this.handlePostMultipart(rc, rc.queryParams().get("operationName"), variables, initialValue, extensions);
                break;
            }
            case "application/graphql": {
                if (body == null) {
                    rc.fail(400, (Throwable)VertxException.noStackTrace((String)"No body"));
                    return;
                }
                GraphQLQuery graphQLQuery = new GraphQLQuery().setQuery(body.toString()).setOperationName(rc.queryParams().get("operationName")).setVariables(variables).setInitialValue(initialValue).setExtensions(extensions);
                this.executeOne(rc, graphQLQuery);
                break;
            }
            default: {
                rc.fail(415);
            }
        }
    }

    private void handlePostJson(RoutingContext rc, Buffer body, String operationName, Map<String, Object> variables, Object initialValue, Map<String, Object> extensions) {
        GraphQLInput graphQLInput;
        try {
            graphQLInput = GraphQLInput.decode(body);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        if (graphQLInput instanceof GraphQLBatch) {
            this.handlePostBatch(rc, (GraphQLBatch)graphQLInput, operationName, variables, initialValue, extensions);
        } else if (graphQLInput instanceof GraphQLQuery) {
            this.handlePostQuery(rc, (GraphQLQuery)graphQLInput, operationName, variables, initialValue, extensions);
        } else {
            rc.fail(500);
        }
    }

    private void handlePostBatch(RoutingContext rc, GraphQLBatch batch, String operationName, Map<String, Object> variables, Object initialValue, Map<String, Object> extensions) {
        if (!this.options.isRequestBatchingEnabled()) {
            rc.fail(400);
            return;
        }
        for (GraphQLQuery query : batch) {
            if (operationName != null) {
                query.setOperationName(operationName);
            }
            if (variables != null) {
                query.setVariables(variables);
            }
            if (initialValue != null) {
                query.setInitialValue(initialValue);
            }
            if (extensions != null) {
                query.setExtensions(extensions);
            }
            if (query.getQuery() != null) continue;
            Map<String, Object> exts = query.getExtensions();
            if (exts != null && exts.containsKey("persistedQuery")) {
                query.setQuery("PersistedQueryMarker");
                continue;
            }
            this.failQueryMissing(rc);
            return;
        }
        this.executeBatch(rc, batch);
    }

    private void executeBatch(RoutingContext rc, GraphQLBatch batch) {
        ArrayList<Future<JsonObject>> futures = new ArrayList<Future<JsonObject>>(batch.size());
        for (GraphQLQuery graphQLQuery : batch) {
            futures.add(this.execute(rc, graphQLQuery));
        }
        Future.all(futures).map(cf -> new JsonArray(cf.list()).toBuffer()).onComplete(ar -> this.sendResponse(rc, (AsyncResult<Buffer>)ar));
    }

    private void handlePostQuery(RoutingContext rc, GraphQLQuery query, String operationName, Map<String, Object> variables, Object initialValue, Map<String, Object> extensions) {
        if (operationName != null) {
            query.setOperationName(operationName);
        }
        if (variables != null) {
            query.setVariables(variables);
        }
        if (initialValue != null) {
            query.setInitialValue(initialValue);
        }
        if (extensions != null) {
            query.setExtensions(extensions);
        }
        if (query.getQuery() == null) {
            Map<String, Object> exts = query.getExtensions();
            if (exts != null && exts.containsKey("persistedQuery")) {
                query.setQuery("PersistedQueryMarker");
            } else {
                this.failQueryMissing(rc);
                return;
            }
        }
        this.executeOne(rc, query);
    }

    private void handlePostMultipart(RoutingContext rc, String operationName, Map<String, Object> variables, Object initialValue, Map<String, Object> extensions) {
        GraphQLInput graphQLInput;
        if (!this.options.isRequestMultipartEnabled()) {
            rc.fail(415);
            return;
        }
        try {
            graphQLInput = this.parseMultipartAttributes(rc);
        }
        catch (Exception e) {
            rc.fail(400, (Throwable)e);
            return;
        }
        if (graphQLInput instanceof GraphQLBatch) {
            this.handlePostBatch(rc, (GraphQLBatch)graphQLInput, operationName, variables, initialValue, extensions);
        } else if (graphQLInput instanceof GraphQLQuery) {
            this.handlePostQuery(rc, (GraphQLQuery)graphQLInput, operationName, variables, initialValue, extensions);
        } else {
            rc.fail(500);
        }
    }

    private GraphQLInput parseMultipartAttributes(RoutingContext rc) {
        MultiMap attrs = rc.request().formAttributes();
        Map filesMap = (Map)Json.decodeValue((String)attrs.get("map"), Map.class);
        GraphQLInput graphQLInput = GraphQLInput.decode(Json.decodeValue((String)attrs.get("operations")));
        HashMap variablesMap = new HashMap();
        List<GraphQLQuery> batch = graphQLInput instanceof GraphQLBatch ? (GraphQLBatch)graphQLInput : Collections.singletonList((GraphQLQuery)graphQLInput);
        int i = 0;
        for (GraphQLQuery query : batch) {
            HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
            variables.put("variables", query.getVariables());
            variablesMap.put(String.valueOf(i), variables);
            ++i;
        }
        for (Map.Entry entry : filesMap.entrySet()) {
            for (Object fullPath : (List)entry.getValue()) {
                Map variables;
                String[] path = ((String)fullPath).split("\\.");
                int end = path.length;
                int idx = -1;
                if (IS_NUMBER.matcher(path[end - 1]).matches()) {
                    idx = Integer.parseInt(path[end - 1]);
                    --end;
                }
                int start = 0;
                if (IS_NUMBER.matcher(path[0]).matches()) {
                    variables = (Map)variablesMap.get(path[0]);
                    ++start;
                } else {
                    variables = (Map)variablesMap.get("0");
                }
                String attr = path[--end];
                Map obj = variables;
                while (start < end) {
                    String token = path[start];
                    obj = (Map)obj.get(token);
                    ++start;
                }
                FileUpload file = rc.fileUploads().stream().filter(f -> f.name().equals(entry.getKey())).findFirst().orElse(null);
                if (file == null) continue;
                if (idx == -1) {
                    obj.put(attr, file);
                    continue;
                }
                ((List)obj.get(attr)).set(idx, file);
            }
        }
        return graphQLInput;
    }

    private void executeOne(RoutingContext rc, GraphQLQuery query) {
        this.execute(rc, query).map(JsonObject::toBuffer).onComplete(ar -> this.sendResponse(rc, (AsyncResult<Buffer>)ar));
    }

    private Future<JsonObject> execute(final RoutingContext rc, GraphQLQuery query) {
        Map<String, Object> extensions;
        Object initialValue;
        Map<String, Object> variables;
        final ExecutionInput.Builder builder = ExecutionInput.newExecutionInput();
        builder.query(query.getQuery());
        String operationName = query.getOperationName();
        if (operationName != null) {
            builder.operationName(operationName);
        }
        if ((variables = query.getVariables()) != null) {
            builder.variables(variables);
        }
        if ((initialValue = query.getInitialValue()) != null) {
            builder.root(initialValue);
        }
        if ((extensions = query.getExtensions()) != null) {
            builder.extensions(extensions);
        }
        builder.graphQLContext(Collections.singletonMap(RoutingContext.class, rc));
        if (this.beforeExecuteHandler != null) {
            this.beforeExecuteHandler.handle((Object)new ExecutionInputBuilderWithContext<RoutingContext>(){

                @Override
                public RoutingContext context() {
                    return rc;
                }

                @Override
                public ExecutionInput.Builder builder() {
                    return builder;
                }
            });
        }
        return Future.fromCompletionStage((CompletionStage)this.graphQL.executeAsync(builder.build()), (Context)rc.vertx().getOrCreateContext()).map(executionResult -> new JsonObject(executionResult.toSpecification()));
    }

    private String getContentType(RoutingContext rc) {
        String contentType = rc.parsedHeaders().contentType().value();
        return contentType.isEmpty() ? "application/json" : contentType.toLowerCase();
    }

    private Map<String, Object> getVariablesFromQueryParam(RoutingContext rc) throws Exception {
        String variablesParam = rc.queryParams().get("variables");
        if (variablesParam == null) {
            return null;
        }
        return new JsonObject(variablesParam).getMap();
    }

    private Object getInitialValueFromQueryParam(RoutingContext rc) throws Exception {
        String initialParam = rc.queryParams().get("initialValue");
        if (initialParam == null || initialParam.isEmpty()) {
            return null;
        }
        return Json.decodeValue((String)initialParam);
    }

    private Map<String, Object> getExtensionsFromQueryParam(RoutingContext rc) throws Exception {
        String extensionsParam = rc.queryParams().get("extensions");
        if (extensionsParam == null) {
            return null;
        }
        return new JsonObject(extensionsParam).getMap();
    }

    private void sendResponse(RoutingContext rc, AsyncResult<Buffer> ar) {
        if (ar.succeeded()) {
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end((Buffer)ar.result());
        } else {
            rc.fail(ar.cause());
        }
    }

    private void failQueryMissing(RoutingContext rc) {
        rc.fail(400, (Throwable)VertxException.noStackTrace((String)"Query is missing"));
    }
}

