/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.codec.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.codec.BodyCodec;
import io.vertx.ext.web.codec.spi.BodyStream;

public class StreamingBodyCodec
implements BodyCodec<Void> {
    private final WriteStream<Buffer> stream;
    private final boolean close;
    private Throwable error;

    public StreamingBodyCodec(WriteStream<Buffer> stream) {
        this(stream, true);
    }

    public StreamingBodyCodec(WriteStream<Buffer> stream, boolean close) {
        this.stream = stream;
        this.close = close;
    }

    public void init() {
        this.stream.exceptionHandler(err -> {
            StreamingBodyCodec streamingBodyCodec = this;
            synchronized (streamingBodyCodec) {
                this.error = err;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BodyStream<Void> stream() throws Exception {
        StreamingBodyCodec streamingBodyCodec = this;
        synchronized (streamingBodyCodec) {
            if (this.error != null) {
                if (this.error instanceof Exception) {
                    throw (Exception)this.error;
                }
                throw new VertxException(this.error);
            }
            return new BodyStream<Void>(){
                final Promise<Void> promise = Promise.promise();

                @Override
                public Future<Void> result() {
                    return this.promise.future();
                }

                public void handle(Throwable cause) {
                    this.promise.tryFail(cause);
                }

                public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
                    StreamingBodyCodec.this.stream.exceptionHandler(handler);
                    return this;
                }

                public Future<Void> write(Buffer data) {
                    return StreamingBodyCodec.this.stream.write((Object)data);
                }

                public Future<Void> end() {
                    if (StreamingBodyCodec.this.close) {
                        return StreamingBodyCodec.this.stream.end().onComplete(ar -> {
                            if (ar.succeeded()) {
                                this.promise.tryComplete();
                            } else {
                                this.promise.tryFail(ar.cause());
                            }
                        });
                    }
                    this.promise.tryComplete();
                    return Future.succeededFuture();
                }

                public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
                    StreamingBodyCodec.this.stream.setWriteQueueMaxSize(maxSize);
                    return this;
                }

                public boolean writeQueueFull() {
                    return StreamingBodyCodec.this.stream.writeQueueFull();
                }

                public WriteStream<Buffer> drainHandler(Handler<Void> handler) {
                    StreamingBodyCodec.this.stream.drainHandler(handler);
                    return this;
                }
            };
        }
    }
}

