/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.codec.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.codec.BodyCodec;
import io.vertx.ext.web.codec.spi.BodyStream;
import java.util.function.Function;

public class BodyCodecImpl<T>
implements BodyCodec<T> {
    public static final Function<Buffer, Void> VOID_DECODER = buff -> null;
    public static final Function<Buffer, String> UTF8_DECODER = Buffer::toString;
    public static final Function<Buffer, JsonObject> JSON_OBJECT_DECODER = buff -> new JsonObject(buff.toString());
    public static final BodyCodec<String> STRING = new BodyCodecImpl<String>(UTF8_DECODER);
    public static final BodyCodec<Void> NONE = new BodyCodecImpl<Void>(VOID_DECODER);
    public static final BodyCodec<Buffer> BUFFER = new BodyCodecImpl<Buffer>(Function.identity());
    public static final BodyCodec<JsonObject> JSON_OBJECT = new BodyCodecImpl<JsonObject>(JSON_OBJECT_DECODER);
    private final Function<Buffer, T> decoder;

    public static BodyCodecImpl<String> string(String encoding) {
        return new BodyCodecImpl<String>(buff -> buff.toString(encoding));
    }

    public static <T> BodyCodec<T> json(Class<T> type) {
        return new BodyCodecImpl<T>(BodyCodecImpl.jsonDecoder(type));
    }

    public static <T> Function<Buffer, T> jsonDecoder(Class<T> type) {
        return buff -> Json.decodeValue((String)buff.toString(), (Class)type);
    }

    public BodyCodecImpl(Function<Buffer, T> decoder) {
        this.decoder = decoder;
    }

    @Override
    public void create(Handler<AsyncResult<BodyStream<T>>> handler) {
        handler.handle((Object)Future.succeededFuture((Object)new BodyStream<T>(){
            Buffer buffer = Buffer.buffer();
            Future<T> state = Future.future();

            public void handle(Throwable cause) {
                if (!this.state.isComplete()) {
                    this.state.fail(cause);
                }
            }

            @Override
            public Future<T> result() {
                return this.state;
            }

            public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
                return this;
            }

            public WriteStream<Buffer> write(Buffer data) {
                this.buffer.appendBuffer(data);
                return this;
            }

            public void end() {
                if (!this.state.isComplete()) {
                    Object result;
                    if (this.buffer.length() > 0) {
                        try {
                            result = BodyCodecImpl.this.decoder.apply(this.buffer);
                        }
                        catch (Throwable t) {
                            this.state.fail(t);
                            return;
                        }
                    } else {
                        result = null;
                    }
                    this.state.complete(result);
                }
            }

            public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
                return this;
            }

            public boolean writeQueueFull() {
                return false;
            }

            public WriteStream<Buffer> drainHandler(Handler<Void> handler) {
                return this;
            }
        }));
    }
}

