/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientForm;
import io.vertx.core.http.ClientMultipartForm;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.http.HttpClientInternal;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.ClientPhase;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import io.vertx.ext.web.client.impl.HttpResponseImpl;
import io.vertx.ext.web.client.spi.CacheStore;
import io.vertx.ext.web.codec.spi.BodyStream;
import io.vertx.ext.web.multipart.MultipartForm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HttpContext<T> {
    private final HttpClientInternal client;
    private final WebClientOptions options;
    private final List<Handler<HttpContext<?>>> interceptors;
    private final ContextInternal context;
    private final PromiseInternal<HttpResponse<T>> promise;
    private HttpRequestImpl<T> request;
    private Object body;
    private String contentType;
    private Map<String, Object> attrs;
    private int interceptorIdx;
    private boolean invoking;
    private boolean invokeNext;
    private ClientPhase phase;
    private RequestOptions requestOptions;
    private HttpClientRequest clientRequest;
    private HttpClientResponse clientResponse;
    private HttpResponse<T> response;
    private Throwable failure;
    private int redirects;
    private List<String> redirectedLocations = Collections.emptyList();
    private CacheStore privateCacheStore;

    HttpContext(ContextInternal context, HttpClientInternal client, WebClientOptions options, List<Handler<HttpContext<?>>> interceptors, PromiseInternal<HttpResponse<T>> promise) {
        this.context = context;
        this.client = client;
        this.options = options;
        this.interceptors = interceptors;
        this.promise = promise;
    }

    public HttpContext<T> duplicate() {
        return new HttpContext<T>(this.context, this.client, this.options, this.interceptors, this.promise);
    }

    public Future<HttpResponse<T>> future() {
        return this.promise.future();
    }

    public HttpClientRequest clientRequest() {
        return this.clientRequest;
    }

    public HttpClientResponse clientResponse() {
        return this.clientResponse;
    }

    public ClientPhase phase() {
        return this.phase;
    }

    public HttpRequest<T> request() {
        return this.request;
    }

    public RequestOptions requestOptions() {
        return this.requestOptions;
    }

    public void requestOptions(RequestOptions requestOptions) {
        this.requestOptions = requestOptions;
    }

    public HttpResponse<T> response() {
        return this.response;
    }

    public HttpContext<T> response(HttpResponse<T> response) {
        this.response = response;
        return this;
    }

    public int redirects() {
        return this.redirects;
    }

    public HttpContext<T> redirects(int redirects) {
        this.redirects = redirects;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public Object body() {
        return this.body;
    }

    public Throwable failure() {
        return this.failure;
    }

    public List<String> redirectedLocations() {
        return this.redirectedLocations;
    }

    public CacheStore privateCacheStore() {
        return this.privateCacheStore;
    }

    public HttpContext<T> privateCacheStore(CacheStore cacheStore) {
        this.privateCacheStore = cacheStore;
        return this;
    }

    public void prepareRequest(HttpRequest<T> request, String contentType, Object body) {
        this.request = (HttpRequestImpl)request;
        this.contentType = contentType;
        this.body = body;
        this.fire(ClientPhase.PREPARE_REQUEST);
    }

    public void createRequest(RequestOptions requestOptions) {
        this.requestOptions = requestOptions;
        this.fire(ClientPhase.CREATE_REQUEST);
    }

    public void sendRequest(HttpClientRequest clientRequest) {
        this.clientRequest = clientRequest;
        this.fire(ClientPhase.SEND_REQUEST);
    }

    private void handleFollowRedirect() {
        this.fire(ClientPhase.CREATE_REQUEST);
    }

    public void receiveResponse(HttpClientResponse clientResponse) {
        int sc = clientResponse.statusCode();
        int maxRedirects = this.request.followRedirects() ? this.client.options().getMaxRedirects() : 0;
        this.clientResponse = clientResponse;
        if (this.redirects < maxRedirects && sc >= 300 && sc < 400) {
            ++this.redirects;
            Future next = (Future)this.client.redirectHandler().apply(clientResponse);
            if (next != null) {
                if (this.redirectedLocations.isEmpty()) {
                    this.redirectedLocations = new ArrayList<String>();
                }
                this.redirectedLocations.add(clientResponse.getHeader(HttpHeaders.LOCATION));
                next.onComplete(ar -> {
                    if (ar.succeeded()) {
                        RequestOptions options;
                        this.requestOptions = options = (RequestOptions)ar.result();
                        this.fire(ClientPhase.FOLLOW_REDIRECT);
                    } else {
                        this.fail(ar.cause());
                    }
                });
                return;
            }
        }
        this.clientResponse = clientResponse;
        this.fire(ClientPhase.RECEIVE_RESPONSE);
    }

    public void dispatchResponse(HttpResponse<T> response) {
        this.response = response;
        this.fire(ClientPhase.DISPATCH_RESPONSE);
    }

    public boolean fail(Throwable cause) {
        if (this.phase == ClientPhase.FAILURE) {
            return false;
        }
        this.failure = cause;
        this.fire(ClientPhase.FAILURE);
        return true;
    }

    private void fire(ClientPhase phase) {
        Objects.requireNonNull(phase);
        this.phase = phase;
        this.interceptorIdx = 0;
        if (this.invoking) {
            this.invokeNext = true;
        } else {
            this.next();
        }
    }

    public void next() {
        if (this.invoking) {
            this.invokeNext = true;
        } else {
            while (this.interceptorIdx < this.interceptors.size()) {
                Handler<HttpContext<?>> interceptor = this.interceptors.get(this.interceptorIdx);
                this.invoking = true;
                ++this.interceptorIdx;
                try {
                    interceptor.handle((Object)this);
                }
                catch (Exception e) {
                    this.failure = e;
                    this.invokeNext = false;
                    this.phase = ClientPhase.FAILURE;
                    break;
                }
                finally {
                    this.invoking = false;
                }
                if (!this.invokeNext) {
                    return;
                }
                this.invokeNext = false;
            }
            this.interceptorIdx = 0;
            this.execute();
        }
    }

    private void execute() {
        switch (this.phase) {
            case PREPARE_REQUEST: {
                this.handlePrepareRequest();
                break;
            }
            case CREATE_REQUEST: {
                this.handleCreateRequest();
                break;
            }
            case SEND_REQUEST: {
                this.handleSendRequest();
                break;
            }
            case FOLLOW_REDIRECT: {
                this.handleFollowRedirect();
                break;
            }
            case RECEIVE_RESPONSE: {
                this.handleReceiveResponse();
                break;
            }
            case DISPATCH_RESPONSE: {
                this.handleDispatchResponse();
                break;
            }
            case FAILURE: {
                this.handleFailure();
            }
        }
    }

    private void handleFailure() {
        HttpClientRequest req = this.clientRequest;
        if (req != null) {
            this.clientRequest = null;
            req.reset();
        }
        if (this.body != null) {
            if (this.body instanceof Pipe) {
                ((Pipe)this.body).close();
            }
            this.body = null;
        }
        this.promise.tryFail(this.failure);
    }

    private void handleDispatchResponse() {
        this.promise.tryComplete(this.response);
    }

    private void handlePrepareRequest() {
        RequestOptions requestOptions;
        this.redirects = 0;
        try {
            requestOptions = this.request.buildRequestOptions();
        }
        catch (Exception e) {
            this.fail(e);
            return;
        }
        if (this.contentType != null) {
            String prev = requestOptions.getHeaders().get(HttpHeaders.CONTENT_TYPE);
            if (prev == null) {
                requestOptions.addHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.contentType);
            } else {
                this.contentType = prev;
            }
        }
        if (!(this.body instanceof Pipe)) {
            if (this.body instanceof MultipartForm) {
                try {
                    ClientForm form;
                    boolean multipart = "multipart/form-data".equals(this.contentType);
                    if (multipart) {
                        ClientMultipartForm multipartForm = ClientMultipartForm.multipartForm();
                        multipartForm.mixed(this.request.multipartMixed());
                        form = multipartForm;
                    } else {
                        form = ClientForm.form();
                    }
                    form.charset(((MultipartForm)this.body).getCharset());
                    ((MultipartForm)this.body).forEach(part -> {
                        if (part.isAttribute()) {
                            form.attribute(part.name(), part.value());
                        } else {
                            ClientMultipartForm multipartForm = (ClientMultipartForm)form;
                            if (part.isText().booleanValue()) {
                                if (part.pathname() != null) {
                                    multipartForm.textFileUpload(part.name(), part.filename(), part.mediaType(), part.pathname());
                                } else {
                                    multipartForm.textFileUpload(part.name(), part.filename(), part.mediaType(), part.content());
                                }
                            } else if (part.pathname() != null) {
                                multipartForm.binaryFileUpload(part.name(), part.filename(), part.mediaType(), part.pathname());
                            } else {
                                multipartForm.binaryFileUpload(part.name(), part.filename(), part.mediaType(), part.content());
                            }
                        }
                    });
                    this.body = form;
                }
                catch (Exception e) {
                    this.fail(e);
                    return;
                }
            } else if (this.body == null && "application/json".equals(this.contentType)) {
                this.body = Buffer.buffer((String)"null");
            } else if (this.body instanceof JsonObject) {
                this.body = ((JsonObject)this.body).toBuffer();
            } else if (this.body != null && !(this.body instanceof Buffer)) {
                this.body = Json.encodeToBuffer((Object)this.body);
            }
        }
        if (this.body instanceof Buffer) {
            Buffer buffer = (Buffer)this.body;
            requestOptions.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)("" + buffer.length()));
        }
        this.createRequest(requestOptions);
    }

    private void handleCreateRequest() {
        this.client.request(this.requestOptions).onComplete(ar1 -> {
            if (ar1.succeeded()) {
                this.sendRequest((HttpClientRequest)ar1.result());
            } else {
                this.fail(ar1.cause());
            }
        });
    }

    private void handleReceiveResponse() {
        BodyStream stream;
        try {
            stream = this.request.bodyCodec().stream();
        }
        catch (Exception e) {
            this.fail(e);
            return;
        }
        HttpClientResponse resp = this.clientResponse;
        resp.pipeTo((WriteStream)stream).compose(v -> stream.result()).map(result -> new HttpResponseImpl<Object>(resp.version(), resp.statusCode(), resp.statusMessage(), resp.headers(), resp.trailers(), resp.cookies(), result, this.redirectedLocations)).onComplete(ar -> {
            if (ar.succeeded()) {
                this.dispatchResponse((HttpResponse)ar.result());
            } else {
                this.fail(ar.cause());
            }
        });
    }

    private void handleSendRequest() {
        this.clientRequest.response().onComplete(ar -> {
            this.clientRequest = null;
            if (ar.succeeded()) {
                this.receiveResponse(((HttpClientResponse)ar.result()).pause());
            } else {
                this.fail(ar.cause());
            }
        });
        this.doSendRequest(this.clientRequest);
    }

    private void doSendRequest(HttpClientRequest request) {
        Object bodyToSend = this.body;
        if (bodyToSend != null) {
            this.body = null;
            if (bodyToSend instanceof Pipe) {
                Pipe pipe = (Pipe)bodyToSend;
                if (this.request.headers == null || !this.request.headers.contains(HttpHeaders.CONTENT_LENGTH)) {
                    request.setChunked(true);
                }
                pipe.endOnFailure(false);
                pipe.to((WriteStream)request).onComplete(ar2 -> {
                    if (ar2.failed()) {
                        request.reset(0L, ar2.cause());
                    }
                });
            } else if (bodyToSend instanceof ClientForm) {
                request.send((ClientForm)bodyToSend);
            } else {
                Buffer buffer = (Buffer)bodyToSend;
                request.send(buffer);
            }
        } else {
            request.send();
        }
    }

    public <T> T get(String key) {
        return (T)(this.attrs != null ? this.attrs.get(key) : null);
    }

    public HttpContext<T> set(String key, Object value) {
        if (value == null) {
            if (this.attrs != null) {
                this.attrs.remove(key);
            }
        } else {
            if (this.attrs == null) {
                this.attrs = new HashMap<String, Object>();
            }
            this.attrs.put(key, value);
        }
        return this;
    }
}

