/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.predicate.ResponsePredicate;
import io.vertx.ext.web.client.predicate.ResponsePredicateResult;
import io.vertx.ext.web.codec.BodyCodec;
import io.vertx.ext.web.multipart.MultipartForm;
import java.util.function.Function;

@VertxGen
public interface HttpRequest<T> {
    @Fluent
    public HttpRequest<T> method(HttpMethod var1);

    @Fluent
    public HttpRequest<T> port(int var1);

    public <U> HttpRequest<U> as(BodyCodec<U> var1);

    @Fluent
    public HttpRequest<T> host(String var1);

    @Fluent
    public HttpRequest<T> virtualHost(String var1);

    @Fluent
    public HttpRequest<T> uri(String var1);

    @Fluent
    public HttpRequest<T> putHeaders(MultiMap var1);

    @Fluent
    public HttpRequest<T> putHeader(String var1, String var2);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public HttpRequest<T> putHeader(String var1, Iterable<String> var2);

    @CacheReturn
    public MultiMap headers();

    @Fluent
    public HttpRequest<T> authentication(Credentials var1);

    @Fluent
    default public HttpRequest<T> basicAuthentication(String id, String password) {
        return this.authentication(new UsernamePasswordCredentials(id, password).applyHttpChallenge(null));
    }

    @Fluent
    default public HttpRequest<T> basicAuthentication(Buffer id, Buffer password) {
        return this.basicAuthentication(id.toString(), password.toString());
    }

    @Fluent
    default public HttpRequest<T> bearerTokenAuthentication(String bearerToken) {
        return this.authentication(new TokenCredentials(bearerToken).applyHttpChallenge(null));
    }

    @Fluent
    public HttpRequest<T> ssl(Boolean var1);

    @Fluent
    public HttpRequest<T> timeout(long var1);

    @Fluent
    public HttpRequest<T> addQueryParam(String var1, String var2);

    @Fluent
    public HttpRequest<T> setQueryParam(String var1, String var2);

    @Fluent
    public HttpRequest<T> followRedirects(boolean var1);

    @Fluent
    default public HttpRequest<T> expect(Function<HttpResponse<Void>, ResponsePredicateResult> predicate) {
        return this.expect(predicate::apply);
    }

    @Fluent
    public HttpRequest<T> expect(ResponsePredicate var1);

    public MultiMap queryParams();

    public HttpRequest<T> copy();

    public HttpRequest<T> multipartMixed(boolean var1);

    public void sendStream(ReadStream<Buffer> var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendStream(ReadStream<Buffer> body) {
        Promise promise = Promise.promise();
        this.sendStream(body, (Handler<AsyncResult<HttpResponse<T>>>)promise);
        return promise.future();
    }

    public void sendBuffer(Buffer var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendBuffer(Buffer body) {
        Promise promise = Promise.promise();
        this.sendBuffer(body, (Handler<AsyncResult<HttpResponse<T>>>)promise);
        return promise.future();
    }

    public void sendJsonObject(JsonObject var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendJsonObject(JsonObject body) {
        Promise promise = Promise.promise();
        this.sendJsonObject(body, (Handler<AsyncResult<HttpResponse<T>>>)promise);
        return promise.future();
    }

    public void sendJson(@Nullable Object var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendJson(@Nullable Object body) {
        Promise promise = Promise.promise();
        this.sendJson(body, (Handler<AsyncResult<HttpResponse<T>>>)promise);
        return promise.future();
    }

    public void sendForm(MultiMap var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendForm(MultiMap body) {
        Promise promise = Promise.promise();
        this.sendForm(body, (Handler<AsyncResult<HttpResponse<T>>>)promise);
        return promise.future();
    }

    public void sendMultipartForm(MultipartForm var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendMultipartForm(MultipartForm body) {
        Promise promise = Promise.promise();
        this.sendMultipartForm(body, (Handler<AsyncResult<HttpResponse<T>>>)promise);
        return promise.future();
    }

    public void send(Handler<AsyncResult<HttpResponse<T>>> var1);

    default public Future<HttpResponse<T>> send() {
        Promise promise = Promise.promise();
        this.send((Handler<AsyncResult<HttpResponse<T>>>)promise);
        return promise.future();
    }
}

