/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import io.vertx.ext.web.codec.impl.BodyCodecImpl;
import java.net.MalformedURLException;
import java.net.URL;

public class WebClientImpl
implements WebClient {
    private final HttpClient client;
    private final WebClientOptions options;

    public WebClientImpl(HttpClient client, WebClientOptions options) {
        this.client = client;
        this.options = new WebClientOptions(options);
    }

    @Override
    public HttpRequest<Buffer> get(int port, String host, String requestURI) {
        return this.request(HttpMethod.GET, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> get(String requestURI) {
        return this.request(HttpMethod.GET, requestURI);
    }

    @Override
    public HttpRequest<Buffer> get(String host, String requestURI) {
        return this.request(HttpMethod.GET, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> getAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.GET, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> post(String requestURI) {
        return this.request(HttpMethod.POST, requestURI);
    }

    @Override
    public HttpRequest<Buffer> post(String host, String requestURI) {
        return this.request(HttpMethod.POST, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> post(int port, String host, String requestURI) {
        return this.request(HttpMethod.POST, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> put(String requestURI) {
        return this.request(HttpMethod.PUT, requestURI);
    }

    @Override
    public HttpRequest<Buffer> put(String host, String requestURI) {
        return this.request(HttpMethod.PUT, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> put(int port, String host, String requestURI) {
        return this.request(HttpMethod.PUT, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> delete(String host, String requestURI) {
        return this.request(HttpMethod.DELETE, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> delete(String requestURI) {
        return this.request(HttpMethod.DELETE, requestURI);
    }

    @Override
    public HttpRequest<Buffer> delete(int port, String host, String requestURI) {
        return this.request(HttpMethod.DELETE, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> patch(String requestURI) {
        return this.request(HttpMethod.PATCH, requestURI);
    }

    @Override
    public HttpRequest<Buffer> patch(String host, String requestURI) {
        return this.request(HttpMethod.PATCH, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> patch(int port, String host, String requestURI) {
        return this.request(HttpMethod.PATCH, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> head(String requestURI) {
        return this.request(HttpMethod.HEAD, requestURI);
    }

    @Override
    public HttpRequest<Buffer> head(String host, String requestURI) {
        return this.request(HttpMethod.HEAD, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> head(int port, String host, String requestURI) {
        return this.request(HttpMethod.HEAD, port, host, requestURI);
    }

    @Override
    public HttpRequest<Buffer> postAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.POST, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> putAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.PUT, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> deleteAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.DELETE, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> patchAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.PATCH, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> headAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.HEAD, absoluteURI);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, String requestURI) {
        return new HttpRequestImpl<Buffer>(this.client, method, this.options.isSsl(), this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, BodyCodecImpl.BUFFER, this.options);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, RequestOptions requestOptions) {
        return new HttpRequestImpl<Buffer>(this.client, method, requestOptions.isSsl(), requestOptions.getPort(), requestOptions.getHost(), requestOptions.getURI(), BodyCodecImpl.BUFFER, this.options);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, String host, String requestURI) {
        return new HttpRequestImpl<Buffer>(this.client, method, this.options.isSsl(), this.options.getDefaultPort(), host, requestURI, BodyCodecImpl.BUFFER, this.options);
    }

    @Override
    public HttpRequest<Buffer> request(HttpMethod method, int port, String host, String requestURI) {
        return new HttpRequestImpl<Buffer>(this.client, method, this.options.isSsl(), port, host, requestURI, BodyCodecImpl.BUFFER, this.options);
    }

    @Override
    public HttpRequest<Buffer> requestAbs(HttpMethod method, String surl) {
        URL url;
        try {
            url = new URL(surl);
        }
        catch (MalformedURLException e) {
            throw new VertxException("Invalid url: " + surl);
        }
        boolean ssl = false;
        int port = url.getPort();
        String protocol = url.getProtocol();
        char chend = protocol.charAt(protocol.length() - 1);
        if (chend == 'p') {
            if (port == -1) {
                port = 80;
            }
        } else if (chend == 's') {
            ssl = true;
            if (port == -1) {
                port = 443;
            }
        }
        return new HttpRequestImpl<Buffer>(this.client, method, ssl, port, url.getHost(), url.getFile(), BodyCodecImpl.BUFFER, this.options);
    }

    @Override
    public void close() {
        this.client.close();
    }
}

