/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.service;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.api.service.ServiceResponse;
import java.util.Base64;
import java.util.Map;

public class ServiceResponseConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, ServiceResponse obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "payload": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPayload(Buffer.buffer((byte[])Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "statusCode": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setStatusCode(((Number)member.getValue()).intValue());
                    break;
                }
                case "statusMessage": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setStatusMessage((String)member.getValue());
                }
            }
        }
    }

    static void toJson(ServiceResponse obj, JsonObject json) {
        ServiceResponseConverter.toJson(obj, json.getMap());
    }

    static void toJson(ServiceResponse obj, Map<String, Object> json) {
        if (obj.getPayload() != null) {
            json.put("payload", Base64.getEncoder().encodeToString(obj.getPayload().getBytes()));
        }
        if (obj.getStatusCode() != null) {
            json.put("statusCode", obj.getStatusCode());
        }
        if (obj.getStatusMessage() != null) {
            json.put("statusMessage", obj.getStatusMessage());
        }
    }
}

