/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.impl.SingleValueParameterTypeValidator;
import java.util.regex.Pattern;

public class StringTypeValidator
extends SingleValueParameterTypeValidator<String> {
    private Pattern pattern;
    private Integer minLength;
    private Integer maxLength;

    public StringTypeValidator(String pattern, Integer minLength, Integer maxLength, String defaultValue) {
        super(defaultValue);
        this.pattern = pattern != null ? Pattern.compile(pattern) : null;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public StringTypeValidator(String pattern, String defaultValue) {
        this(pattern, null, null, defaultValue);
    }

    public StringTypeValidator(String pattern) {
        this(pattern, null, null, null);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    private boolean checkMinLength(String value) {
        if (this.minLength != null) {
            return value.length() >= this.minLength;
        }
        return true;
    }

    private boolean checkMaxLength(String value) {
        if (this.maxLength != null) {
            return value.length() <= this.maxLength;
        }
        return true;
    }

    @Override
    public RequestParameter isValidSingleParam(String value) {
        if (!this.checkMinLength(value)) {
            throw ValidationException.ValidationExceptionFactory.generateNotMatchValidationException("Value doesn't respect min length " + this.minLength);
        }
        if (!this.checkMaxLength(value)) {
            throw ValidationException.ValidationExceptionFactory.generateNotMatchValidationException("Value doesn't respect max length " + this.maxLength);
        }
        if (this.pattern != null && !this.pattern.matcher(value).matches()) {
            throw ValidationException.ValidationExceptionFactory.generateNotMatchValidationException("Value doesn't respect pattern " + this.pattern);
        }
        return RequestParameter.create(value);
    }
}

