require 'vertx-web/router'
require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.api.contract.RouterFactory
module VertxWebApiContract
  module RouterFactory
    #  Mount to paths that have to follow a security schema a security handler
    # @param [String] securitySchemaName 
    # @yield 
    # @return [self]
    def add_security_handler(securitySchemaName=nil)
      if securitySchemaName.class == String && block_given?
        @j_del.java_method(:addSecurityHandler, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(securitySchemaName,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_security_handler(#{securitySchemaName})"
    end
    #  Add an handler to a path with a method. If combination path/method is not available in
    #  specification, it will throw a {Nil}. Deprecated in favour of
    #  operation id
    # @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    # @param [String] path 
    # @yield 
    # @return [self]
    def add_handler(method=nil,path=nil)
      if method.class == Symbol && path.class == String && block_given?
        @j_del.java_method(:addHandler, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(method.to_s),path,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_handler(#{method},#{path})"
    end
    #  Add a failure handler to a path with a method. If combination path/method is not available in
    #  specification, it will throw a {Nil}. Deprecated in favour of
    #  operation id
    # @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    # @param [String] path 
    # @yield 
    # @return [self]
    def add_failure_handler(method=nil,path=nil)
      if method.class == Symbol && path.class == String && block_given?
        @j_del.java_method(:addFailureHandler, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(method.to_s),path,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_failure_handler(#{method},#{path})"
    end
    #  Override options
    # @param [Hash] options 
    # @return [self]
    def set_options(options=nil)
      if options.class == Hash && !block_given?
        @j_del.java_method(:setOptions, [Java::IoVertxExtWebApiContract::RouterFactoryOptions.java_class]).call(Java::IoVertxExtWebApiContract::RouterFactoryOptions.new(::Vertx::Util::Utils.to_json_object(options)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_options(#{options})"
    end
    #  Get options of router factory. For more info {Hash}
    # @return [Hash] 
    def get_options
      if !block_given?
        return @j_del.java_method(:getOptions, []).call() != nil ? JSON.parse(@j_del.java_method(:getOptions, []).call().toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_options()"
    end
    #  Deprecated. Instantiate {Hash}
    #  and load it using {::VertxWebApiContract::RouterFactory#set_options}
    # @yield 
    # @return [self]
    def set_validation_failure_handler
      if block_given?
        @j_del.java_method(:setValidationFailureHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_validation_failure_handler()"
    end
    #  Deprecated. Instantiate {Hash}
    #  and load it using {::VertxWebApiContract::RouterFactory#set_options}
    # @param [true,false] enable 
    # @return [self]
    def enable_validation_failure_handler(enable=nil)
      if (enable.class == TrueClass || enable.class == FalseClass) && !block_given?
        @j_del.java_method(:enableValidationFailureHandler, [Java::boolean.java_class]).call(enable)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling enable_validation_failure_handler(#{enable})"
    end
    #  Deprecated. Instantiate {Hash}
    #  and load it using {::VertxWebApiContract::RouterFactory#set_options}
    # @param [true,false] enable 
    # @return [self]
    def mount_operations_without_handlers(enable=nil)
      if (enable.class == TrueClass || enable.class == FalseClass) && !block_given?
        @j_del.java_method(:mountOperationsWithoutHandlers, [Java::boolean.java_class]).call(enable)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling mount_operations_without_handlers(#{enable})"
    end
    #  Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
    #  without assigned handlers<br/>
    #  <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.
    # @return [::VertxWeb::Router] 
    def get_router
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getRouter, []).call(),::VertxWeb::Router)
      end
      raise ArgumentError, "Invalid arguments when calling get_router()"
    end
  end
  class RouterFactoryImpl
    include RouterFactory
    # @private
    # @param j_del [::VertxWebApiContract::RouterFactory] the java delegate
    def initialize(j_del, j_arg_Specification=nil)
      @j_del = j_del
      @j_arg_Specification = j_arg_Specification != nil ? j_arg_Specification : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxWebApiContract::RouterFactory] the underlying java delegate
    def j_del
      @j_del
    end
  end
end
