/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.VertxException;
import io.vertx.ext.web.api.validation.ParameterLocation;
import io.vertx.ext.web.api.validation.ParameterValidationRule;

public class ValidationException
extends VertxException {
    private String parameterName;
    private ParameterValidationRule validationRule;
    private String value;
    private final ErrorType errorType;

    private ValidationException(String message, String parameterName, String value, ParameterValidationRule validationRule, ErrorType errorType) {
        super(message != null && message.length() != 0 ? message : "ValidationException{parameterName='" + parameterName + '\'' + ", value='" + value + '\'' + ", errorType=" + (Object)((Object)errorType) + '}');
        this.parameterName = parameterName;
        this.validationRule = validationRule;
        this.value = value;
        this.errorType = errorType;
    }

    public ValidationException(String message, ErrorType error) {
        this(message, null, null, null, error);
    }

    public ValidationException(ErrorType error) {
        this(null, null, null, null, error);
    }

    public ValidationException(String message) {
        this(message, null, null, null, null);
    }

    public @Nullable String parameterName() {
        return this.parameterName;
    }

    public ParameterValidationRule validationRule() {
        return this.validationRule;
    }

    public String value() {
        return this.value;
    }

    public ErrorType type() {
        return this.errorType;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setValidationRule(ParameterValidationRule validationRule) {
        this.validationRule = validationRule;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "ValidationException{parameterName='" + this.parameterName + '\'' + ", value='" + this.value + '\'' + ", errorType=" + (Object)((Object)this.errorType) + '}';
    }

    public static class ValidationExceptionFactory {
        public static ValidationException generateWrongContentTypeExpected(String actualContentType, String expectedContentType) {
            return new ValidationException("Wrong Content-Type header. Actual: " + actualContentType + " Expected: " + expectedContentType, "Content-Type", actualContentType, null, ErrorType.WRONG_CONTENT_TYPE);
        }

        public static ValidationException generateNotFoundValidationException(String parameterName, ParameterLocation location) {
            return new ValidationException("Error during validation of request. Parameter \"" + parameterName + "\" inside " + location.s + "not found", parameterName, null, null, ErrorType.NOT_FOUND);
        }

        public static ValidationException generateUnexpectedArrayValidationException(String parameterName, ParameterValidationRule validationRule) {
            return new ValidationException("Parameter " + parameterName + " not expected as an array", parameterName, null, validationRule, ErrorType.UNEXPECTED_ARRAY);
        }

        public static ValidationException generateUnexpectedSingleStringValidationException(String parameterName, ParameterValidationRule validationRule) {
            return new ValidationException("Parameter " + parameterName + "  expected as array", parameterName, null, validationRule, ErrorType.UNEXPECTED_SINGLE_STRING);
        }

        public static ValidationException generateNotMatchValidationException(String parameterName, String value, ParameterValidationRule validationRule) {
            return new ValidationException("Error during validation of request. Parameter \"" + parameterName + "\" does not match the validator rules", parameterName, value, validationRule, ErrorType.NO_MATCH);
        }

        public static ValidationException generateFileNotFoundValidationException(String filename, String contentType) {
            return new ValidationException("Error during validation: File not found or wrong content type. Expected file name: \"" + filename + "\". Expected content type: \"" + contentType + "\"", filename, null, null, ErrorType.FILE_NOT_FOUND);
        }

        public static ValidationException generateEmptyValueValidationException(String parameterName, ParameterValidationRule rule, ParameterLocation location) {
            return new ValidationException("Parameter " + parameterName + " inside " + location.s + " is empty", parameterName, null, rule, ErrorType.EMPTY_VALUE);
        }

        public static ValidationException generateUnexpectedArraySizeValidationException(Integer maxItems, Integer minItems, Integer actualSize) {
            return new ValidationException("Array parameter have unexpected size: " + minItems + "<=" + actualSize + "<=" + maxItems, ErrorType.UNEXPECTED_ARRAY_SIZE);
        }

        public static ValidationException generateDeserializationError(String message) {
            return new ValidationException(message, ErrorType.DESERIALIZATION_ERROR);
        }

        public static ValidationException generateObjectFieldNotFound(String fieldName) {
            return new ValidationException("Object field not found but required: " + fieldName, ErrorType.OBJECT_FIELD_NOT_FOUND);
        }

        public static ValidationException generateNotMatchValidationException(String message) {
            return new ValidationException(message, ErrorType.NO_MATCH);
        }

        public static ValidationException generateNotParsableJsonBodyException(String message) {
            return new ValidationException(message, ErrorType.JSON_NOT_PARSABLE);
        }

        public static ValidationException generateInvalidJsonBodyException(String message) {
            return new ValidationException(message, ErrorType.JSON_INVALID);
        }

        public static ValidationException generateInvalidXMLBodyException(String message) {
            return new ValidationException(message, ErrorType.XML_INVALID);
        }
    }

    @VertxGen
    public static enum ErrorType {
        NO_MATCH,
        NOT_FOUND,
        UNEXPECTED_ARRAY,
        UNEXPECTED_SINGLE_STRING,
        FILE_NOT_FOUND,
        WRONG_CONTENT_TYPE,
        EMPTY_VALUE,
        UNEXPECTED_ARRAY_SIZE,
        DESERIALIZATION_ERROR,
        OBJECT_FIELD_NOT_FOUND,
        JSON_NOT_PARSABLE,
        JSON_INVALID,
        XML_INVALID;

    }
}

