/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.parser.ObjectMapperFactory;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.vertx.ext.web.api.validation.SpecFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OpenApi3Utils {
    private static final Pattern COMPONENTS_REFS_MATCHER = Pattern.compile("^\\#\\/components\\/schemas\\/(.+)$");
    private static final String COMPONENTS_REFS_SUBSTITUTION = "\\#\\/definitions\\/$1";

    public static ParseOptions getParseOptions() {
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        options.setResolveCombinators(false);
        options.setResolveFully(true);
        return options;
    }

    public static boolean isParameterArrayType(Parameter parameter) {
        if (parameter.getSchema() != null && parameter.getSchema().getType() != null) {
            return parameter.getSchema().getType().equals("array");
        }
        return false;
    }

    public static boolean isParameterObjectOrAllOfType(Parameter parameter) {
        return OpenApi3Utils.isSchemaObjectOrAllOfType(parameter.getSchema());
    }

    public static boolean isSchemaObjectOrAllOfType(Schema schema) {
        return OpenApi3Utils.isSchemaObject(schema) || OpenApi3Utils.isAllOfSchema(schema);
    }

    public static boolean isSchemaObject(Schema schema) {
        return schema != null && ("object".equals(schema.getType()) || schema.getProperties() != null);
    }

    public static boolean isRequiredParam(Schema schema, String parameterName) {
        return schema != null && schema.getRequired() != null && schema.getRequired().contains(parameterName);
    }

    public static boolean isRequiredParam(Parameter param) {
        return param != null ? param.getRequired() : false;
    }

    public static String resolveStyle(Parameter param) {
        if (param.getStyle() != null) {
            return param.getStyle().toString();
        }
        switch (param.getIn()) {
            case "query": {
                return "form";
            }
            case "path": {
                return "simple";
            }
            case "header": {
                return "simple";
            }
            case "cookie": {
                return "form";
            }
        }
        return null;
    }

    public static boolean isOneOfSchema(Schema schema) {
        if (!(schema instanceof ComposedSchema)) {
            return false;
        }
        ComposedSchema composedSchema = (ComposedSchema)schema;
        return composedSchema.getOneOf() != null && composedSchema.getOneOf().size() != 0;
    }

    public static boolean isAnyOfSchema(Schema schema) {
        if (!(schema instanceof ComposedSchema)) {
            return false;
        }
        ComposedSchema composedSchema = (ComposedSchema)schema;
        return composedSchema.getAnyOf() != null && composedSchema.getAnyOf().size() != 0;
    }

    public static boolean isAllOfSchema(Schema schema) {
        if (!(schema instanceof ComposedSchema)) {
            return false;
        }
        ComposedSchema composedSchema = (ComposedSchema)schema;
        return composedSchema.getAllOf() != null && composedSchema.getAllOf().size() != 0;
    }

    public static boolean resolveAllowEmptyValue(Parameter parameter) {
        if (parameter.getAllowEmptyValue() != null) {
            if (!"form".equals(OpenApi3Utils.resolveStyle(parameter))) {
                return false;
            }
            return parameter.getAllowEmptyValue();
        }
        return false;
    }

    public static <T extends Enum<?>> T searchEnum(Class<T> enumeration, String search) {
        for (Enum each : (Enum[])enumeration.getEnumConstants()) {
            if (each.name().compareToIgnoreCase(search) != 0) continue;
            return (T)each;
        }
        return null;
    }

    public static String resolveContentTypeRegex(String listContentTypes) {
        if (listContentTypes.contains(",")) {
            String[] contentTypes;
            StringBuilder stringBuilder = new StringBuilder();
            for (String contentType : contentTypes = listContentTypes.split(",")) {
                stringBuilder.append(Pattern.quote(contentType.trim()) + "|");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
        return Pattern.quote(listContentTypes);
    }

    public static List<Parameter> mergeParameters(List<Parameter> operationParameters, List<Parameter> parentParameters) {
        if (parentParameters == null && operationParameters == null) {
            return new ArrayList<Parameter>();
        }
        if (operationParameters == null) {
            return new ArrayList<Parameter>(parentParameters);
        }
        if (parentParameters == null) {
            return new ArrayList<Parameter>(operationParameters);
        }
        ArrayList<Parameter> result = new ArrayList<Parameter>(operationParameters);
        ArrayList<Parameter> actualParams = new ArrayList<Parameter>(operationParameters);
        for (int i = 0; i < parentParameters.size(); ++i) {
            for (int j = 0; j < actualParams.size(); ++j) {
                Parameter parentParam = parentParameters.get(i);
                Parameter actualParam = (Parameter)actualParams.get(j);
                if (parentParam.getIn().equalsIgnoreCase(actualParam.getIn()) && parentParam.getName().equals(actualParam.getName())) continue;
                result.add(parentParam);
            }
        }
        return result;
    }

    public static Map<String, ObjectField> resolveAllOfArrays(List<Schema> allOfSchemas) {
        HashMap<String, ObjectField> properties = new HashMap<String, ObjectField>();
        for (Schema schema : allOfSchemas) {
            if (schema.getType() != null && !schema.getType().equals("object")) {
                throw new SpecFeatureNotSupportedException("allOf only allows inner object types");
            }
            for (Map.Entry entry : schema.getProperties().entrySet()) {
                properties.put((String)entry.getKey(), new ObjectField((Schema)entry.getValue(), (String)entry.getKey(), schema));
            }
        }
        return properties;
    }

    public static Map<String, ObjectField> solveObjectParameters(Schema schema) {
        if (OpenApi3Utils.isSchemaObjectOrAllOfType(schema)) {
            if (OpenApi3Utils.isAllOfSchema(schema)) {
                ComposedSchema composedSchema = (ComposedSchema)schema;
                return OpenApi3Utils.resolveAllOfArrays(new ArrayList<Schema>(composedSchema.getAllOf()));
            }
            HashMap<String, ObjectField> properties = new HashMap<String, ObjectField>();
            for (Map.Entry entry : schema.getProperties().entrySet()) {
                properties.put((String)entry.getKey(), new ObjectField((Schema)entry.getValue(), (String)entry.getKey(), schema));
            }
            return properties;
        }
        return null;
    }

    public static JsonNode generateSanitizedJsonSchemaNode(Schema s, OpenAPI oas) {
        ObjectNode node = (ObjectNode)ObjectMapperFactory.createJson().convertValue((Object)s, ObjectNode.class);
        OpenApi3Utils.walkAndSolve(node, node, oas);
        return node;
    }

    private static void walkAndSolve(ObjectNode n, ObjectNode root, OpenAPI oas) {
        if (n.has("$ref")) {
            OpenApi3Utils.replaceRef(n, root, oas);
        } else if (n.has("allOf")) {
            Iterator it = n.get("allOf").iterator();
            while (it.hasNext()) {
                OpenApi3Utils.walkAndSolve((ObjectNode)it.next(), root, oas);
            }
        } else if (n.has("anyOf")) {
            Iterator it = n.get("anyOf").iterator();
            while (it.hasNext()) {
                OpenApi3Utils.walkAndSolve((ObjectNode)it.next(), root, oas);
            }
        } else if (n.has("oneOf")) {
            Iterator it = n.get("oneOf").iterator();
            while (it.hasNext()) {
                OpenApi3Utils.walkAndSolve((ObjectNode)it.next(), root, oas);
            }
        } else if (n.has("properties")) {
            ObjectNode properties = (ObjectNode)n.get("properties");
            Iterator it = properties.fieldNames();
            while (it.hasNext()) {
                OpenApi3Utils.walkAndSolve((ObjectNode)properties.get((String)it.next()), root, oas);
            }
        } else if (n.has("items")) {
            OpenApi3Utils.walkAndSolve((ObjectNode)n.get("items"), root, oas);
        }
    }

    private static void replaceRef(ObjectNode n, ObjectNode root, OpenAPI oas) {
        String oldRef = n.get("$ref").asText();
        Matcher m = COMPONENTS_REFS_MATCHER.matcher(oldRef);
        if (m.lookingAt()) {
            String schemaName = m.group(1);
            String newRef = m.replaceAll(COMPONENTS_REFS_SUBSTITUTION);
            n.remove("$ref");
            n.put("$ref", newRef);
            if (!root.has("definitions") || !root.get("definitions").has(schemaName)) {
                Schema s = (Schema)oas.getComponents().getSchemas().get(schemaName);
                ObjectNode schema = (ObjectNode)ObjectMapperFactory.createJson().convertValue((Object)s, ObjectNode.class);
                if (!root.has("definitions")) {
                    ObjectNode definitions = root.putObject("definitions");
                    definitions.set(schemaName, (JsonNode)schema);
                } else {
                    ((ObjectNode)root.get("definitions")).set(schemaName, (JsonNode)schema);
                }
                OpenApi3Utils.walkAndSolve(schema, root, oas);
            }
        } else {
            throw new RuntimeException("Wrong ref! " + oldRef);
        }
    }

    public static List<MediaType> extractTypesFromMediaTypesMap(Map<String, MediaType> types, Predicate<String> matchingFunction) {
        return types.entrySet().stream().filter(e -> matchingFunction.test((String)e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    protected static class ObjectField {
        Schema schema;
        boolean required;

        public ObjectField(Schema schema, String name, Schema superSchema) {
            this.schema = schema;
            this.required = superSchema.getRequired() != null && superSchema.getRequired().contains(name);
        }

        public Schema getSchema() {
            return this.schema;
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

