/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3.impl;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.ResolverCache;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.contract.RouterFactoryException;
import io.vertx.ext.web.api.contract.impl.BaseRouterFactory;
import io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenAPI3PathResolver;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenAPI3RequestValidationHandlerImpl;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenApi3Utils;
import io.vertx.ext.web.api.contract.openapi3.impl.SecurityHandlersStore;
import io.vertx.ext.web.handler.ResponseContentTypeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OpenAPI3RouterFactoryImpl
extends BaseRouterFactory<OpenAPI>
implements OpenAPI3RouterFactory {
    Map<String, OperationValue> operations;
    ResolverCache refsCache;
    SecurityHandlersStore securityHandlers;

    public OpenAPI3RouterFactoryImpl(Vertx vertx, OpenAPI spec, ResolverCache refsCache) {
        super(vertx, spec);
        this.refsCache = refsCache;
        this.operations = new LinkedHashMap<String, OperationValue>();
        this.securityHandlers = new SecurityHandlersStore();
        for (Map.Entry pathEntry : spec.getPaths().entrySet()) {
            for (Map.Entry opEntry : ((PathItem)pathEntry.getValue()).readOperationsMap().entrySet()) {
                this.operations.put(((Operation)opEntry.getValue()).getOperationId(), new OperationValue(HttpMethod.valueOf((String)((PathItem.HttpMethod)opEntry.getKey()).name()), (String)pathEntry.getKey(), (Operation)opEntry.getValue(), ((PathItem)pathEntry.getValue()).getParameters()));
            }
        }
    }

    public OpenAPI3RouterFactory addSecuritySchemaScopeValidator(String securitySchemaName, String scopeName, Handler handler) {
        this.securityHandlers.addSecurityRequirement(securitySchemaName, scopeName, (Handler<RoutingContext>)handler);
        return this;
    }

    @Override
    public OpenAPI3RouterFactory addHandlerByOperationId(String operationId, Handler<RoutingContext> handler) {
        if (handler != null) {
            OperationValue op = this.operations.get(operationId);
            if (op == null) {
                throw RouterFactoryException.createOperationIdNotFoundException(operationId);
            }
            op.addUserHandler(handler);
        }
        return this;
    }

    @Override
    public OpenAPI3RouterFactory addFailureHandlerByOperationId(String operationId, Handler<RoutingContext> failureHandler) {
        if (failureHandler != null) {
            OperationValue op = this.operations.get(operationId);
            if (op == null) {
                throw RouterFactoryException.createOperationIdNotFoundException(operationId);
            }
            op.addUserFailureHandler(failureHandler);
        }
        return this;
    }

    public OpenAPI3RouterFactory addSecurityHandler(String securitySchemaName, Handler handler) {
        this.securityHandlers.addSecurityRequirement(securitySchemaName, (Handler<RoutingContext>)handler);
        return this;
    }

    private String resolveOperationId(HttpMethod method, String path) {
        Operation operation;
        PathItem pathObject = (PathItem)((OpenAPI)this.spec).getPaths().get((Object)path);
        if (pathObject == null) {
            throw RouterFactoryException.createPathNotFoundException(path);
        }
        switch (method) {
            case GET: {
                operation = pathObject.getGet();
                break;
            }
            case PUT: {
                operation = pathObject.getPut();
                break;
            }
            case HEAD: {
                operation = pathObject.getHead();
                break;
            }
            case DELETE: {
                operation = pathObject.getDelete();
                break;
            }
            case PATCH: {
                operation = pathObject.getPatch();
                break;
            }
            case POST: {
                operation = pathObject.getPost();
                break;
            }
            case OPTIONS: {
                operation = pathObject.getOptions();
                break;
            }
            case TRACE: {
                operation = pathObject.getTrace();
                break;
            }
            default: {
                throw RouterFactoryException.createPathNotFoundException(path);
            }
        }
        return operation.getOperationId();
    }

    public OpenAPI3RouterFactory addHandler(HttpMethod method, String path, Handler handler) {
        this.addHandlerByOperationId(this.resolveOperationId(method, path), (Handler<RoutingContext>)handler);
        return this;
    }

    public OpenAPI3RouterFactory addFailureHandler(HttpMethod method, String path, Handler failureHandler) {
        this.addFailureHandlerByOperationId(this.resolveOperationId(method, path), (Handler<RoutingContext>)failureHandler);
        return this;
    }

    @Override
    public Router getRouter() {
        Router router = Router.router((Vertx)this.vertx);
        Route globalRoute = router.route();
        globalRoute.handler((Handler)this.options.getBodyHandler());
        List<Handler<RoutingContext>> globalHandlers = this.getOptions().getGlobalHandlers();
        for (Handler<RoutingContext> globalHandler : globalHandlers) {
            globalRoute.handler(globalHandler);
        }
        List<Handler<RoutingContext>> globalSecurityHandlers = this.securityHandlers.solveSecurityHandlers(((OpenAPI)this.spec).getSecurity(), this.getOptions().isRequireSecurityHandlers());
        for (OperationValue operation : this.operations.values()) {
            if (!this.options.isMountNotImplementedHandler() && !operation.isConfigured()) continue;
            ArrayList<Handler<RoutingContext>> handlersToLoad = new ArrayList<Handler<RoutingContext>>();
            ArrayList<Handler<RoutingContext>> failureHandlersToLoad = new ArrayList<Handler<RoutingContext>>();
            if (operation.getOperationModel().getSecurity() != null) {
                handlersToLoad.addAll(this.securityHandlers.solveSecurityHandlers(operation.getOperationModel().getSecurity(), this.getOptions().isRequireSecurityHandlers()));
            } else {
                handlersToLoad.addAll(globalSecurityHandlers);
            }
            OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(operation.getOperationModel(), operation.getParameters(), (OpenAPI)this.spec, this.refsCache);
            handlersToLoad.add(validationHandler);
            if (this.options.isMountValidationFailureHandler()) {
                failureHandlersToLoad.add(this.options.getValidationFailureHandler());
            }
            if (operation.isConfigured()) {
                handlersToLoad.addAll(operation.getUserHandlers());
                failureHandlersToLoad.addAll(operation.getUserFailureHandlers());
            } else {
                handlersToLoad.add(this.options.getNotImplementedFailureHandler());
            }
            OpenAPI3PathResolver pathResolver = new OpenAPI3PathResolver(operation.getPath(), operation.getParameters());
            Route route = pathResolver.solve().map(solvedRegex -> router.routeWithRegex(operation.getMethod(), solvedRegex.toString())).orElseGet(() -> router.route(operation.getMethod(), operation.getPath()));
            HashSet consumes = new HashSet();
            HashSet produces = new HashSet();
            if (operation.getOperationModel().getRequestBody() != null && operation.getOperationModel().getRequestBody().getContent() != null) {
                consumes.addAll(operation.getOperationModel().getRequestBody().getContent().keySet());
            }
            if (operation.getOperationModel().getResponses() != null) {
                for (ApiResponse apiResponse : operation.getOperationModel().getResponses().values()) {
                    if (apiResponse.getContent() == null) continue;
                    produces.addAll(apiResponse.getContent().keySet());
                }
            }
            for (String string : consumes) {
                route.consumes(string);
            }
            for (String string : produces) {
                route.produces(string);
            }
            if (this.options.isMountResponseContentTypeHandler() && produces.size() != 0) {
                route.handler((Handler)ResponseContentTypeHandler.create());
            }
            route.setRegexGroupsNames(new ArrayList<String>(pathResolver.getMappedGroups().values()));
            for (Handler handler : handlersToLoad) {
                route.handler(handler);
            }
            for (Handler handler : failureHandlersToLoad) {
                route.failureHandler(handler);
            }
        }
        return router;
    }

    private class OperationValue {
        private HttpMethod method;
        private String path;
        private Operation operationModel;
        private List<Parameter> parameters;
        private List<Handler<RoutingContext>> userHandlers;
        private List<Handler<RoutingContext>> userFailureHandlers;

        private OperationValue(HttpMethod method, String path, Operation operationModel, Collection<? extends Parameter> parentParameters) {
            this.method = method;
            this.path = path;
            this.operationModel = operationModel;
            ArrayList<Parameter> opParams = operationModel.getParameters() == null ? new ArrayList<Parameter>() : new ArrayList(operationModel.getParameters());
            ArrayList<Parameter> parentParams = parentParameters == null ? new ArrayList<Parameter>() : new ArrayList<Parameter>(parentParameters);
            this.parameters = OpenApi3Utils.mergeParameters(opParams, parentParams);
            this.userHandlers = new ArrayList<Handler<RoutingContext>>();
            this.userFailureHandlers = new ArrayList<Handler<RoutingContext>>();
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public Operation getOperationModel() {
            return this.operationModel;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public String getPath() {
            return this.path;
        }

        public void addUserHandler(Handler<RoutingContext> userHandler) {
            this.userHandlers.add(userHandler);
        }

        public void addUserFailureHandler(Handler<RoutingContext> userFailureHandler) {
            this.userFailureHandlers.add(userFailureHandler);
        }

        public List<Handler<RoutingContext>> getUserHandlers() {
            return this.userHandlers;
        }

        public List<Handler<RoutingContext>> getUserFailureHandlers() {
            return this.userFailureHandlers;
        }

        public boolean isConfigured() {
            return this.userHandlers.size() != 0;
        }
    }
}

