/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.contract.RouterFactoryOptionsConverter;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.ArrayList;
import java.util.List;

@DataObject(generateConverter=true, publicConverter=false)
public class RouterFactoryOptions {
    public static final Handler<RoutingContext> DEFAULT_VALIDATION_HANDLER = routingContext -> {
        if (routingContext.failure() instanceof ValidationException) {
            routingContext.response().setStatusCode(400).setStatusMessage("Bad Request").end(routingContext.failure().getMessage());
        } else {
            routingContext.next();
        }
    };
    public static final boolean DEFAULT_MOUNT_VALIDATION_FAILURE_HANDLER = true;
    public static final Handler<RoutingContext> DEFAULT_NOT_IMPLEMENTED_HANDLER = routingContext -> routingContext.response().setStatusCode(501).setStatusMessage("Not Implemented").end();
    public static final boolean DEFAULT_MOUNT_NOT_IMPLEMENTED_HANDLER = true;
    public static final boolean DEFAULT_REQUIRE_SECURITY_HANDLERS = true;
    public static final boolean DEFAULT_MOUNT_RESPONSE_CONTENT_TYPE_HANDLER = true;
    private Handler<RoutingContext> validationFailureHandler;
    private boolean mountValidationFailureHandler;
    private Handler<RoutingContext> notImplementedFailureHandler;
    private boolean mountNotImplementedHandler;
    private boolean requireSecurityHandlers;
    private boolean mountResponseContentTypeHandler;
    private BodyHandler bodyHandler;
    private List<Handler<RoutingContext>> globalHandlers;

    public RouterFactoryOptions() {
        this.init();
    }

    public RouterFactoryOptions(JsonObject json) {
        this.init();
        RouterFactoryOptionsConverter.fromJson(json, this);
    }

    public RouterFactoryOptions(RouterFactoryOptions other) {
        this.validationFailureHandler = other.getValidationFailureHandler();
        this.mountValidationFailureHandler = other.isMountValidationFailureHandler();
        this.notImplementedFailureHandler = other.getNotImplementedFailureHandler();
        this.mountNotImplementedHandler = other.isMountNotImplementedHandler();
        this.requireSecurityHandlers = other.isRequireSecurityHandlers();
        this.mountResponseContentTypeHandler = other.isMountResponseContentTypeHandler();
        this.bodyHandler = other.getBodyHandler();
        this.globalHandlers = other.getGlobalHandlers();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RouterFactoryOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.validationFailureHandler = DEFAULT_VALIDATION_HANDLER;
        this.mountValidationFailureHandler = true;
        this.notImplementedFailureHandler = DEFAULT_NOT_IMPLEMENTED_HANDLER;
        this.mountNotImplementedHandler = true;
        this.requireSecurityHandlers = true;
        this.mountResponseContentTypeHandler = true;
        this.bodyHandler = BodyHandler.create();
        this.globalHandlers = new ArrayList<Handler<RoutingContext>>();
    }

    public Handler<RoutingContext> getValidationFailureHandler() {
        return this.validationFailureHandler;
    }

    @Fluent
    public RouterFactoryOptions setValidationFailureHandler(Handler<RoutingContext> validationFailureHandler) {
        this.validationFailureHandler = validationFailureHandler;
        return this;
    }

    public boolean isMountValidationFailureHandler() {
        return this.mountValidationFailureHandler;
    }

    @Fluent
    public RouterFactoryOptions setMountValidationFailureHandler(boolean mountGlobalValidationFailureHandler) {
        this.mountValidationFailureHandler = mountGlobalValidationFailureHandler;
        return this;
    }

    public Handler<RoutingContext> getNotImplementedFailureHandler() {
        return this.notImplementedFailureHandler;
    }

    @Fluent
    public RouterFactoryOptions setNotImplementedFailureHandler(Handler<RoutingContext> notImplementedFailureHandler) {
        this.notImplementedFailureHandler = notImplementedFailureHandler;
        return this;
    }

    public boolean isMountNotImplementedHandler() {
        return this.mountNotImplementedHandler;
    }

    @Fluent
    public RouterFactoryOptions setMountNotImplementedHandler(boolean mountOperationsWithoutHandler) {
        this.mountNotImplementedHandler = mountOperationsWithoutHandler;
        return this;
    }

    public boolean isRequireSecurityHandlers() {
        return this.requireSecurityHandlers;
    }

    @Fluent
    public RouterFactoryOptions setRequireSecurityHandlers(boolean requireSecurityHandlers) {
        this.requireSecurityHandlers = requireSecurityHandlers;
        return this;
    }

    public boolean isMountResponseContentTypeHandler() {
        return this.mountResponseContentTypeHandler;
    }

    @Fluent
    public RouterFactoryOptions setMountResponseContentTypeHandler(boolean mountResponseContentTypeHandler) {
        this.mountResponseContentTypeHandler = mountResponseContentTypeHandler;
        return this;
    }

    public BodyHandler getBodyHandler() {
        return this.bodyHandler;
    }

    @Fluent
    public RouterFactoryOptions setBodyHandler(BodyHandler bodyHandler) {
        this.bodyHandler = bodyHandler;
        return this;
    }

    public List<Handler<RoutingContext>> getGlobalHandlers() {
        return this.globalHandlers;
    }

    @Fluent
    public RouterFactoryOptions addGlobalHandler(Handler<RoutingContext> globalHandler) {
        this.globalHandlers.add(globalHandler);
        return this;
    }
}

