/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.junit;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RunTestOnContext
implements TestRule {
    private volatile Vertx vertx;
    private final Supplier<Vertx> createVertx;
    private final BiConsumer<Vertx, CountDownLatch> closeVertx;

    public RunTestOnContext() {
        this(new VertxOptions());
    }

    public RunTestOnContext(VertxOptions options) {
        this((Future<Vertx>)Future.succeededFuture((Object)Vertx.vertx((VertxOptions)options)));
    }

    public RunTestOnContext(Supplier<Vertx> createVertx) {
        this(createVertx, (Vertx vertx, Consumer<Void> latch) -> vertx.close().onComplete(ar -> latch.accept(null)));
    }

    public RunTestOnContext(Supplier<Vertx> createVertx, BiConsumer<Vertx, Consumer<Void>> closeVertx) {
        this.createVertx = createVertx;
        this.closeVertx = (vertx, latch) -> closeVertx.accept((Vertx)vertx, v -> latch.countDown());
    }

    public RunTestOnContext(Future<Vertx> createVertx) {
        this(createVertx, (Vertx vertx, Consumer<Void> latch) -> vertx.close().onComplete(ar -> latch.accept(null)));
    }

    public RunTestOnContext(Future<Vertx> createVertx, BiConsumer<Vertx, Consumer<Void>> closeVertx) {
        this.createVertx = () -> {
            try {
                return (Vertx)createVertx.toCompletionStage().toCompletableFuture().get(60L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        };
        this.closeVertx = (vertx, latch) -> closeVertx.accept((Vertx)vertx, v -> latch.countDown());
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                RunTestOnContext.this.vertx = RunTestOnContext.this.createVertx.get();
                try {
                    Context context = RunTestOnContext.this.vertx != null ? RunTestOnContext.this.vertx.getOrCreateContext() : null;
                    VertxUnitRunner.pushContext(context);
                    base.evaluate();
                }
                finally {
                    VertxUnitRunner.popContext();
                    CountDownLatch latch = new CountDownLatch(1);
                    RunTestOnContext.this.closeVertx.accept(RunTestOnContext.this.vertx, latch);
                    try {
                        if (!latch.await(30000L, TimeUnit.MILLISECONDS)) {
                            Logger logger = LoggerFactory.getLogger((Class)description.getTestClass());
                            logger.warn((Object)"Could not close Vert.x in time.");
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
    }
}

