/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.junit;

import io.vertx.ext.unit.junit.Repeat;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatRule
implements TestRule {
    public Statement apply(Statement statement, Description description) {
        Statement result = statement;
        Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
        if (repeat != null) {
            int times = repeat.value();
            boolean silent = repeat.silent();
            result = new RepeatStatement(times, statement, description, silent);
        }
        return result;
    }

    private static class RepeatStatement
    extends Statement {
        private final int times;
        private final Statement statement;
        private final Description description;
        private final boolean silent;

        private RepeatStatement(int times, Statement statement, Description description, boolean silent) {
            this.times = times;
            this.statement = statement;
            this.description = description;
            this.silent = silent;
        }

        public void evaluate() throws Throwable {
            for (int i = 0; i < this.times; ++i) {
                if (!this.silent) {
                    System.out.println("*** Iteration " + (i + 1) + "/" + this.times + " of test " + this.description.getDisplayName());
                }
                this.statement.evaluate();
            }
        }
    }
}

