/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.impl.CompletionImpl;
import java.util.concurrent.atomic.AtomicInteger;

class AsyncImpl
extends CompletionImpl<Void>
implements Async {
    private final int initialCount;
    private final AtomicInteger count;
    private final boolean strict;

    AsyncImpl(int initialCount, boolean strict) {
        this.initialCount = initialCount;
        this.strict = strict;
        this.count = new AtomicInteger(initialCount);
    }

    @Override
    public int count() {
        return this.count.get();
    }

    @Override
    public void countDown() {
        int newValue;
        int oldValue;
        do {
            if ((oldValue = this.count.get()) == 0) {
                newValue = 0;
                if (!this.strict) continue;
                Object msg = this.initialCount == 1 ? "Countdown invoked more than once" : (this.initialCount == 2 ? "Countdown invoked more than twice" : "Countdown invoked more than " + this.initialCount + " times");
                throw new IllegalStateException((String)msg);
            }
            newValue = oldValue - 1;
        } while (!this.count.compareAndSet(oldValue, newValue));
        if (newValue == 0) {
            this.release(null);
        }
    }

    @Override
    public void complete() {
        int value = this.count.getAndSet(0);
        if (value <= 0) {
            throw new IllegalStateException("The Async complete method has been called more than " + this.initialCount + " times, check your test.");
        }
        this.release(null);
    }

    void release(Throwable failure) {
        if (failure != null) {
            this.completable.completeExceptionally(failure);
        } else {
            this.completable.complete(null);
        }
    }
}

