/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.StompServer;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.StompServerHandler;
import io.vertx.ext.stomp.impl.ServerFrameImpl;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSession;

public class StompServerTCPConnectionImpl
implements StompServerConnection {
    private static final Logger log = LoggerFactory.getLogger(StompServerTCPConnectionImpl.class);
    private final StompServer server;
    private final NetSocket socket;
    private final String sessionId;
    protected final Handler<ServerFrame> handler;
    public volatile long lastClientActivity;
    private long pinger = -1L;
    private long ponger = -1L;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public StompServerTCPConnectionImpl(NetSocket socket, StompServer server, Handler<ServerFrame> writingFrameHandler) {
        Objects.requireNonNull(socket);
        Objects.requireNonNull(server);
        this.socket = socket;
        this.server = server;
        this.sessionId = UUID.randomUUID().toString();
        this.handler = writingFrameHandler;
    }

    public StompServerTCPConnectionImpl(StompServer server, Handler<ServerFrame> writingFrameHandler) {
        Objects.requireNonNull(server);
        this.socket = null;
        this.server = server;
        this.handler = writingFrameHandler;
        this.sessionId = UUID.randomUUID().toString();
    }

    @Override
    public StompServerConnection write(Frame frame) {
        if (this.handler != null) {
            this.handler.handle((Object)new ServerFrameImpl(frame, this));
        }
        return this.write(frame.toBuffer(this.server.options().isTrailingLine()));
    }

    @Override
    public StompServerConnection write(Buffer buffer) {
        this.socket.write((Object)buffer);
        return this;
    }

    @Override
    public StompServer server() {
        return this.server;
    }

    @Override
    public StompServerHandler handler() {
        return this.server.stompHandler();
    }

    @Override
    public String session() {
        return this.sessionId;
    }

    @Override
    public SSLSession sslSession() {
        return this.socket.sslSession();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.cancelHeartbeat();
            this.handler().onClose(this);
            this.socket.close();
        }
    }

    @Override
    public void ping() {
        if (this.handler != null) {
            this.handler.handle((Object)new ServerFrameImpl(Frames.PING, this));
        }
        this.socket.write((Object)Buffer.buffer((String)"\n"));
    }

    public synchronized void cancelHeartbeat() {
        if (this.pinger >= 0L) {
            this.server.vertx().cancelTimer(this.pinger);
            this.pinger = -1L;
        }
        if (this.ponger >= 0L) {
            this.server.vertx().cancelTimer(this.ponger);
            this.ponger = -1L;
        }
    }

    @Override
    public void onServerActivity() {
        this.lastClientActivity = System.nanoTime();
    }

    @Override
    public synchronized void configureHeartbeat(long ping, long pong, Handler<StompServerConnection> pingHandler) {
        if (ping > 0L) {
            this.pinger = this.server.vertx().setPeriodic(ping, l -> pingHandler.handle((Object)this));
        }
        if (pong > 0L) {
            this.ponger = this.server.vertx().setPeriodic(pong, l -> {
                long delta = System.nanoTime() - this.lastClientActivity;
                long deltaInMs = TimeUnit.MILLISECONDS.convert(delta, TimeUnit.NANOSECONDS);
                if (deltaInMs > pong * 2L) {
                    log.warn((Object)("Disconnecting client " + this + " - no client activity in the last " + deltaInMs + " ms"));
                    this.close();
                }
            });
        }
    }
}

