/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.stomp.Command;
import io.vertx.ext.stomp.Frame;
import java.util.Map;

public class FrameConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, Frame obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "headers": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            obj.addHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    break;
                }
                case "ack": {
                    break;
                }
                case "command": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCommand(Command.valueOf((String)member.getValue()));
                    break;
                }
                case "body": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setBody(Buffer.fromJson((String)((String)member.getValue())));
                    break;
                }
                case "bodyAsString": {
                    break;
                }
                case "destination": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDestination((String)member.getValue());
                    break;
                }
                case "transaction": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTransaction((String)member.getValue());
                    break;
                }
                case "id": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setId((String)member.getValue());
                    break;
                }
            }
        }
    }

    static void toJson(Frame obj, JsonObject json) {
        FrameConverter.toJson(obj, json.getMap());
    }

    static void toJson(Frame obj, Map<String, Object> json) {
        if (obj.getHeaders() != null) {
            JsonObject map = new JsonObject();
            obj.getHeaders().forEach((key, value) -> map.put(key, value));
            json.put("headers", map);
        }
        if (obj.getAck() != null) {
            json.put("ack", obj.getAck());
        }
        if (obj.getCommand() != null) {
            json.put("command", obj.getCommand().name());
        }
        if (obj.getBody() != null) {
            json.put("body", obj.getBody().toJson());
        }
        if (obj.getBodyAsString() != null) {
            json.put("bodyAsString", obj.getBodyAsString());
        }
        if (obj.getDestination() != null) {
            json.put("destination", obj.getDestination());
        }
        if (obj.getTransaction() != null) {
            json.put("transaction", obj.getTransaction());
        }
        if (obj.getId() != null) {
            json.put("id", obj.getId());
        }
        if (obj.getReceipt() != null) {
            json.put("receipt", obj.getReceipt());
        }
    }
}

