/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.Handler;
import io.vertx.ext.stomp.Destination;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.utils.Headers;
import java.util.List;

public class DefaultUnsubscribeHandler
implements Handler<ServerFrame> {
    public void handle(ServerFrame serverFrame) {
        Frame frame = serverFrame.frame();
        StompServerConnection connection = serverFrame.connection();
        String id = frame.getHeader("id");
        if (id == null) {
            connection.write(Frames.createErrorFrame("Invalid unsubscribe", Headers.create(frame.getHeaders()), "The 'id' header must be set"));
            connection.close();
            return;
        }
        List<Destination> destinations = connection.handler().getDestinations();
        boolean handled = false;
        for (Destination destination : destinations) {
            if (!destination.unsubscribe(connection, frame)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            connection.write(Frames.createErrorFrame("Invalid unsubscribe", Headers.create(frame.getHeaders()), "No subscription associated with the given 'id'"));
            connection.close();
            return;
        }
        Frames.handleReceipt(frame, connection);
    }
}

