/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetServerOptions;
import io.vertx.ext.stomp.StompOptions;
import io.vertx.ext.stomp.StompServerOptionsConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class StompServerOptions
extends NetServerOptions
implements StompOptions {
    public static final int DEFAULT_MAX_HEADER_LENGTH = 10240;
    public static final int DEFAULT_MAX_HEADERS = 1000;
    public static final int DEFAULT_MAX_BODY_LENGTH = 0x6400000;
    public static final int DEFAULT_MAX_FRAME_IN_TRANSACTION = 1000;
    public static final int DEFAULT_TRANSACTION_CHUNK_SIZE = 1000;
    public static final int DEFAULT_MAX_SUBSCRIPTIONS_BY_CLIENT = 1000;
    public static final String DEFAULT_WEBSOCKET_PATH = "/stomp";
    private int maxHeaderLength = 10240;
    private int maxHeaders = 1000;
    private int maxBodyLength = 0x6400000;
    private int maxFrameInTransaction = 1000;
    private List<String> supportedVersions = new ArrayList<String>(DEFAULT_SUPPORTED_VERSIONS);
    private boolean secured = false;
    private boolean sendErrorOnNoSubscriptions = false;
    private long ackTimeout = 10000L;
    private int timeFactor = 1;
    private JsonObject heartbeat = DEFAULT_STOMP_HEARTBEAT;
    private int transactionChunkSize = 1000;
    private int maxSubscriptionsByClient = 1000;
    private boolean websocketBridge = false;
    private String websocketPath = "/stomp";
    private boolean disableTCPServer;
    private boolean trailingLine = false;

    public StompServerOptions() {
        this.setPort(61613);
        this.setHost("0.0.0.0");
    }

    public StompServerOptions(StompServerOptions other) {
        super((NetServerOptions)other);
        this.maxHeaderLength = other.maxHeaderLength;
        this.maxHeaders = other.maxHeaders;
        this.maxBodyLength = other.maxBodyLength;
        this.supportedVersions = new ArrayList<String>(other.supportedVersions);
        this.secured = other.secured;
        this.sendErrorOnNoSubscriptions = other.sendErrorOnNoSubscriptions;
        this.ackTimeout = other.ackTimeout;
        this.timeFactor = other.timeFactor;
        this.heartbeat = other.heartbeat;
        this.maxFrameInTransaction = other.maxFrameInTransaction;
        this.transactionChunkSize = other.transactionChunkSize;
        this.maxSubscriptionsByClient = other.maxSubscriptionsByClient;
        this.websocketBridge = other.websocketBridge;
        this.websocketPath = other.websocketPath;
        this.disableTCPServer = other.disableTCPServer;
        this.trailingLine = other.trailingLine;
    }

    public StompServerOptions(JsonObject json) {
        super(json);
        StompServerOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        StompServerOptionsConverter.toJson(this, json);
        return json;
    }

    public int getMaxBodyLength() {
        return this.maxBodyLength;
    }

    public StompServerOptions setMaxBodyLength(int maxBodyLength) {
        this.maxBodyLength = maxBodyLength;
        return this;
    }

    public int getMaxHeaderLength() {
        return this.maxHeaderLength;
    }

    public StompServerOptions setMaxHeaderLength(int maxHeaderLength) {
        this.maxHeaderLength = maxHeaderLength;
        return this;
    }

    public int getMaxHeaders() {
        return this.maxHeaders;
    }

    public StompServerOptions setMaxHeaders(int maxHeaders) {
        this.maxHeaders = maxHeaders;
        return this;
    }

    public List<String> getSupportedVersions() {
        return this.supportedVersions;
    }

    public StompServerOptions setSupportedVersions(List<String> supportedVersions) {
        this.supportedVersions = supportedVersions;
        return this;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public StompServerOptions setSecured(boolean secured) {
        this.secured = secured;
        return this;
    }

    public boolean isSendErrorOnNoSubscriptions() {
        return this.sendErrorOnNoSubscriptions;
    }

    public StompServerOptions setSendErrorOnNoSubscriptions(boolean sendErrorOnNoSubscriptions) {
        this.sendErrorOnNoSubscriptions = sendErrorOnNoSubscriptions;
        return this;
    }

    public int getTimeFactor() {
        return this.timeFactor;
    }

    public StompServerOptions setTimeFactor(int timeFactor) {
        if (timeFactor <= 0) {
            throw new IllegalArgumentException("The time factor must be strictly positive");
        }
        this.timeFactor = timeFactor;
        return this;
    }

    public StompServerOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public StompServerOptions setPort(int port) {
        if (port != -1) {
            super.setPort(port);
        } else {
            this.disableTCPServer = true;
        }
        return this;
    }

    public int getPort() {
        if (this.disableTCPServer) {
            return -1;
        }
        return super.getPort();
    }

    public StompServerOptions setHost(String host) {
        super.setHost(host);
        return this;
    }

    public JsonObject getHeartbeat() {
        return this.heartbeat;
    }

    public StompServerOptions setHeartbeat(JsonObject heartbeat) {
        this.heartbeat = heartbeat;
        return this;
    }

    public int getMaxFrameInTransaction() {
        return this.maxFrameInTransaction;
    }

    public StompServerOptions setMaxFrameInTransaction(int maxFrameInTransaction) {
        this.maxFrameInTransaction = maxFrameInTransaction;
        return this;
    }

    public int getTransactionChunkSize() {
        return this.transactionChunkSize;
    }

    public StompServerOptions setTransactionChunkSize(int transactionChunkSize) {
        if (transactionChunkSize <= 0) {
            throw new IllegalArgumentException("Chunk size must be strictly positive");
        }
        this.transactionChunkSize = transactionChunkSize;
        return this;
    }

    public int getMaxSubscriptionsByClient() {
        return this.maxSubscriptionsByClient;
    }

    public StompServerOptions setMaxSubscriptionsByClient(int maxSubscriptionsByClient) {
        this.maxSubscriptionsByClient = maxSubscriptionsByClient;
        return this;
    }

    public boolean isWebsocketBridge() {
        return this.websocketBridge;
    }

    public StompServerOptions setWebsocketBridge(boolean websocketBridge) {
        this.websocketBridge = websocketBridge;
        return this;
    }

    public String getWebsocketPath() {
        return this.websocketPath;
    }

    public StompServerOptions setWebsocketPath(String websocketPath) {
        this.websocketPath = websocketPath;
        return this;
    }

    public boolean isTrailingLine() {
        return this.trailingLine;
    }

    public StompServerOptions setTrailingLine(boolean trailingLine) {
        this.trailingLine = trailingLine;
        return this;
    }
}

