/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.Handler;
import io.vertx.ext.stomp.Destination;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.impl.Transaction;
import io.vertx.ext.stomp.impl.Transactions;
import io.vertx.ext.stomp.utils.Headers;
import java.util.List;

public class DefaultNackHandler
implements Handler<ServerFrame> {
    public void handle(ServerFrame sf) {
        StompServerConnection connection = sf.connection();
        String id = sf.frame().getId();
        if (id == null) {
            connection.write(Frames.createErrorFrame("Id header missing", Headers.create(sf.frame().getHeaders()), "Invalid NACK frame - the 'id' must be set"));
            connection.close();
            return;
        }
        String txId = sf.frame().getHeader("transaction");
        if (txId != null) {
            Transaction transaction = Transactions.instance().getTransaction(connection, txId);
            if (transaction == null) {
                Frame errorFrame = Frames.createErrorFrame("No transaction", Headers.create("id", id, "transaction", txId), "Message delivery failed - unknown transaction id in NACK message");
                connection.write(errorFrame);
                connection.close();
                return;
            }
            if (!transaction.addFrameToTransaction(sf.frame())) {
                Frame errorFrame = Frames.createErrorFrame("Frame not added to transaction", Headers.create("id", id, "transaction", txId), "Message delivery failed - the frame cannot be added to the transaction - the number of allowed thread may have been reached");
                Transactions.instance().unregisterTransactionsFromConnection(connection);
                connection.write(errorFrame);
                connection.close();
                return;
            }
            Frames.handleReceipt(sf.frame(), connection);
            return;
        }
        List<Destination> destinations = connection.handler().getDestinations();
        for (Destination destination : destinations) {
            if (destination.nack(connection, sf.frame())) break;
        }
        Frames.handleReceipt(sf.frame(), connection);
    }
}

