/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import io.vertx.ext.stomp.StompClientOptions;
import java.util.ArrayList;
import java.util.Map;

public class StompClientOptionsConverter
implements JsonCodec<StompClientOptions, JsonObject> {
    public static final StompClientOptionsConverter INSTANCE = new StompClientOptionsConverter();

    public JsonObject encode(StompClientOptions value) {
        return value != null ? value.toJson() : null;
    }

    public StompClientOptions decode(JsonObject value) {
        return value != null ? new StompClientOptions(value) : null;
    }

    public Class<StompClientOptions> getTargetClass() {
        return StompClientOptions.class;
    }

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, StompClientOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "acceptedVersions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setAcceptedVersions(list);
                    break;
                }
                case "autoComputeContentLength": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAutoComputeContentLength((Boolean)member.getValue());
                    break;
                }
                case "bypassHostHeader": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBypassHostHeader((Boolean)member.getValue());
                    break;
                }
                case "heartbeat": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setHeartbeat(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHost((String)member.getValue());
                    break;
                }
                case "login": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setLogin((String)member.getValue());
                    break;
                }
                case "passcode": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPasscode((String)member.getValue());
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "trailingLine": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTrailingLine((Boolean)member.getValue());
                    break;
                }
                case "useStompFrame": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setUseStompFrame((Boolean)member.getValue());
                    break;
                }
                case "virtualHost": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setVirtualHost((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(StompClientOptions obj, JsonObject json) {
        StompClientOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(StompClientOptions obj, Map<String, Object> json) {
        if (obj.getAcceptedVersions() != null) {
            JsonArray array = new JsonArray();
            obj.getAcceptedVersions().forEach(item -> array.add(item));
            json.put("acceptedVersions", array);
        }
        json.put("autoComputeContentLength", obj.isAutoComputeContentLength());
        json.put("bypassHostHeader", obj.isBypassHostHeader());
        if (obj.getHeartbeat() != null) {
            json.put("heartbeat", obj.getHeartbeat());
        }
        if (obj.getHost() != null) {
            json.put("host", obj.getHost());
        }
        if (obj.getLogin() != null) {
            json.put("login", obj.getLogin());
        }
        if (obj.getPasscode() != null) {
            json.put("passcode", obj.getPasscode());
        }
        json.put("port", obj.getPort());
        json.put("trailingLine", obj.isTrailingLine());
        json.put("useStompFrame", obj.isUseStompFrame());
        if (obj.getVirtualHost() != null) {
            json.put("virtualHost", obj.getVirtualHost());
        }
    }
}

