/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.stomp.PermittedOptions;
import java.util.ArrayList;
import java.util.List;

@DataObject(generateConverter=false)
public class BridgeOptions {
    public static final boolean DEFAULT_POINT_TO_POINT = false;
    private List<PermittedOptions> inboundPermitted = new ArrayList<PermittedOptions>();
    private List<PermittedOptions> outboundPermitted = new ArrayList<PermittedOptions>();
    private boolean pointToPoint;

    public BridgeOptions() {
        this.pointToPoint = false;
    }

    public BridgeOptions(BridgeOptions that) {
        this.inboundPermitted = that.inboundPermitted;
        this.outboundPermitted = that.outboundPermitted;
        this.pointToPoint = that.pointToPoint;
    }

    public BridgeOptions(JsonObject json) {
        JsonArray inbound = json.getJsonArray("inboundPermitteds");
        JsonArray outbound = json.getJsonArray("outboundPermitteds");
        if (inbound != null) {
            for (Object object : inbound) {
                if (!(object instanceof JsonObject)) {
                    throw new IllegalArgumentException("Invalid type " + object.getClass() + " in inboundPermitteds array");
                }
                this.inboundPermitted.add(new PermittedOptions((JsonObject)object));
            }
        }
        if (outbound != null) {
            for (Object object : outbound) {
                if (!(object instanceof JsonObject)) {
                    throw new IllegalArgumentException("Invalid type " + object.getClass() + " in outboundPermitteds array");
                }
                this.outboundPermitted.add(new PermittedOptions((JsonObject)object));
            }
        }
        this.pointToPoint = json.getBoolean("pointToPoint", Boolean.valueOf(false));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray in = new JsonArray();
        JsonArray out = new JsonArray();
        for (PermittedOptions p : this.inboundPermitted) {
            in.add(p.toJson());
        }
        for (PermittedOptions p : this.outboundPermitted) {
            out.add(p.toJson());
        }
        json.put("inboundPermitteds", in);
        json.put("outboundPermitteds", out);
        json.put("pointToPoint", Boolean.valueOf(this.pointToPoint));
        return json;
    }

    public BridgeOptions addInboundPermitted(PermittedOptions permitted) {
        this.inboundPermitted.add(permitted);
        return this;
    }

    public List<PermittedOptions> getInboundPermitteds() {
        return this.inboundPermitted;
    }

    public void setInboundPermitted(List<PermittedOptions> inboundPermitted) {
        this.inboundPermitted = inboundPermitted;
    }

    public BridgeOptions addOutboundPermitted(PermittedOptions permitted) {
        this.outboundPermitted.add(permitted);
        return this;
    }

    public List<PermittedOptions> getOutboundPermitteds() {
        return this.outboundPermitted;
    }

    public void setOutboundPermitted(List<PermittedOptions> outboundPermitted) {
        this.outboundPermitted = outboundPermitted;
    }

    public BridgeOptions setPointToPoint(boolean v) {
        this.pointToPoint = v;
        return this;
    }

    public boolean isPointToPoint() {
        return this.pointToPoint;
    }
}

