/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.LinkedHashMap;
import java.util.Map;

public class SqlConnectOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, SqlConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHost((String)member.getValue());
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "user": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUser((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "database": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDatabase((String)member.getValue());
                    break;
                }
                case "cachePreparedStatements": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setCachePreparedStatements((Boolean)member.getValue());
                    break;
                }
                case "preparedStatementCacheMaxSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPreparedStatementCacheMaxSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "preparedStatementCacheSqlLimit": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPreparedStatementCacheSqlLimit(((Number)member.getValue()).intValue());
                    break;
                }
                case "properties": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setProperties(map);
                    break;
                }
                case "tracingPolicy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTracingPolicy(TracingPolicy.valueOf((String)((String)member.getValue())));
                    break;
                }
                case "usingDomainSocket": {
                    break;
                }
                case "reconnectAttempts": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectAttempts(((Number)member.getValue()).intValue());
                    break;
                }
                case "reconnectInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "metricsName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMetricsName((String)member.getValue());
                    break;
                }
                case "sslOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setSslOptions(new ClientSSLOptions((JsonObject)member.getValue()));
                }
            }
        }
    }

    static void toJson(SqlConnectOptions obj, JsonObject json) {
        SqlConnectOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(SqlConnectOptions obj, Map<String, Object> json) {
        if (obj.getHost() != null) {
            json.put("host", obj.getHost());
        }
        json.put("port", obj.getPort());
        if (obj.getUser() != null) {
            json.put("user", obj.getUser());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getDatabase() != null) {
            json.put("database", obj.getDatabase());
        }
        json.put("cachePreparedStatements", obj.getCachePreparedStatements());
        json.put("preparedStatementCacheMaxSize", obj.getPreparedStatementCacheMaxSize());
        if (obj.getProperties() != null) {
            JsonObject map = new JsonObject();
            obj.getProperties().forEach((key, value) -> map.put(key, value));
            json.put("properties", map);
        }
        if (obj.getTracingPolicy() != null) {
            json.put("tracingPolicy", obj.getTracingPolicy().name());
        }
        json.put("usingDomainSocket", obj.isUsingDomainSocket());
        json.put("reconnectAttempts", obj.getReconnectAttempts());
        json.put("reconnectInterval", obj.getReconnectInterval());
        if (obj.getMetricsName() != null) {
            json.put("metricsName", obj.getMetricsName());
        }
        if (obj.getSslOptions() != null) {
            json.put("sslOptions", obj.getSslOptions().toJson());
        }
    }
}

