/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowStream;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.tck.Connector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class PreparedQueryTestBase {
    protected Vertx vertx;
    protected Connector<SqlConnection> connector;
    protected SqlConnectOptions options;

    private static void insertIntoTestTable(TestContext ctx, SqlClient client, int amount, Runnable completionHandler) {
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < 10; ++i) {
            client.query("INSERT INTO mutable (id, val) VALUES (" + i + ", 'Whatever-" + i + "')", ctx.asyncAssertSuccess(r1 -> {
                ctx.assertEquals((Object)1, (Object)r1.rowCount());
                if (count.incrementAndGet() == amount) {
                    completionHandler.run();
                }
            }));
        }
    }

    protected void connect(Handler<AsyncResult<SqlConnection>> handler) {
        this.connector.connect(handler);
    }

    protected abstract String statement(String ... var1);

    protected abstract void initConnector();

    @Before
    public void setUp(TestContext ctx) throws Exception {
        this.vertx = Vertx.vertx();
        this.initConnector();
        this.cleanTestTable(ctx);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.connector.close();
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testPrepare(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.prepare(this.statement("SELECT id, message from immutable where id=", ""), ctx.asyncAssertSuccess(result -> conn.close()))));
    }

    @Test
    public void testPrepareError(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT whatever from DOES_NOT_EXIST", ctx.asyncAssertFailure(error -> {}))));
    }

    @Test
    public void testPreparedQuery(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(this.statement("SELECT * FROM immutable WHERE id=", ""), Tuple.of((Object)1), ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)1, (Object)rowSet.size());
            Row row = rowSet.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
            conn.close();
        }))));
    }

    @Test
    public void testPreparedQueryParamCoercionTypeError(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.prepare(this.statement("SELECT * FROM immutable WHERE id=", ""), ctx.asyncAssertSuccess(ps -> ps.execute(Tuple.of((Object)"1"), ctx.asyncAssertFailure(error -> {}))))));
    }

    @Test
    public void testPreparedQueryParamCoercionQuantityError(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.prepare(this.statement("SELECT * FROM immutable WHERE id=", ""), ctx.asyncAssertSuccess(ps -> ps.execute(Tuple.of((Object)1, (Object)2), ctx.asyncAssertFailure(error -> {}))))));
    }

    @Test
    public void testPreparedUpdate(TestContext ctx) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("INSERT INTO mutable (id, val) VALUES (2, 'Whatever')", ctx.asyncAssertSuccess(r1 -> {
            ctx.assertEquals((Object)1, (Object)r1.rowCount());
            conn.preparedQuery("UPDATE mutable SET val = 'Rocks!' WHERE id = 2", ctx.asyncAssertSuccess(res1 -> {
                ctx.assertEquals((Object)1, (Object)res1.rowCount());
                conn.preparedQuery("SELECT val FROM mutable WHERE id = 2", ctx.asyncAssertSuccess(res2 -> {
                    ctx.assertEquals((Object)"Rocks!", res2.iterator().next().getValue(0));
                    conn.close();
                }));
            }));
        }))));
    }

    @Test
    public void testPreparedUpdateWithParams(TestContext ctx) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("INSERT INTO mutable (id, val) VALUES (2, 'Whatever')", ctx.asyncAssertSuccess(r1 -> {
            ctx.assertEquals((Object)1, (Object)r1.rowCount());
            conn.preparedQuery(this.statement("UPDATE mutable SET val = ", " WHERE id = ", ""), Tuple.of((Object)"Rocks Again!!", (Object)2), ctx.asyncAssertSuccess(res1 -> {
                ctx.assertEquals((Object)1, (Object)res1.rowCount());
                conn.preparedQuery(this.statement("SELECT val FROM mutable WHERE id = ", ""), Tuple.of((Object)2), ctx.asyncAssertSuccess(res2 -> {
                    ctx.assertEquals((Object)"Rocks Again!!", res2.iterator().next().getValue(0));
                    conn.close();
                }));
            }));
        }))));
    }

    @Test
    public void testPreparedUpdateWithNullParams(TestContext ctx) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(this.statement("INSERT INTO mutable (val, id) VALUES (", ",", ")"), Tuple.of(null, (Object)1), ctx.asyncAssertFailure(error -> {}))));
    }

    @Test
    public void testQueryCursor(TestContext ctx) {
        Async async = ctx.async();
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("BEGIN", ctx.asyncAssertSuccess(begin -> conn.prepare(this.statement("SELECT * FROM immutable WHERE id=", " OR id=", " OR id=", " OR id=", " OR id=", " OR id=", ""), ctx.asyncAssertSuccess(ps -> {
            Cursor query = ps.cursor(Tuple.of((Object)1, (Object)8, (Object)4, (Object)11, (Object)2, (Object)9));
            query.read(4, ctx.asyncAssertSuccess(result -> {
                ctx.assertNotNull((Object)result.columnsNames());
                ctx.assertEquals((Object)4, (Object)result.size());
                ctx.assertTrue(query.hasMore());
                query.read(4, ctx.asyncAssertSuccess(result2 -> {
                    ctx.assertNotNull((Object)result.columnsNames());
                    ctx.assertEquals((Object)4, (Object)result.size());
                    ctx.assertFalse(query.hasMore());
                    async.complete();
                }));
            }));
        }))))));
    }

    @Test
    public void testQueryCloseCursor(TestContext ctx) {
        Async async = ctx.async();
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("BEGIN", ctx.asyncAssertSuccess(begin -> conn.prepare(this.statement("SELECT * FROM immutable WHERE id=", " OR id=", " OR id=", " OR id=", " OR id=", " OR id=", ""), ctx.asyncAssertSuccess(ps -> {
            Cursor query = ps.cursor(Tuple.of((Object)1, (Object)8, (Object)4, (Object)11, (Object)2, (Object)9));
            query.read(4, ctx.asyncAssertSuccess(results -> {
                ctx.assertEquals((Object)4, (Object)results.size());
                query.close(ctx.asyncAssertSuccess(v1 -> ps.close(ctx.asyncAssertSuccess(v2 -> async.complete()))));
            }));
        }))))));
    }

    @Test
    public void testQueryStreamCloseCursor(TestContext ctx) {
        Async async = ctx.async();
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("BEGIN", ctx.asyncAssertSuccess(begin -> conn.prepare(this.statement("SELECT * FROM immutable WHERE id=", " OR id=", " OR id=", " OR id=", " OR id=", " OR id=", ""), ctx.asyncAssertSuccess(ps -> {
            Cursor stream = ps.cursor(Tuple.of((Object)1, (Object)8, (Object)4, (Object)11, (Object)2, (Object)9));
            stream.read(4, ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)4, (Object)result.size());
                stream.close(ctx.asyncAssertSuccess(v1 -> ps.close(ctx.asyncAssertSuccess(v2 -> async.complete()))));
            }));
        }))))));
    }

    @Test
    public void testStreamQuery(TestContext ctx) {
        Async async = ctx.async();
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("BEGIN", ctx.asyncAssertSuccess(begin -> conn.prepare("SELECT * FROM immutable", ctx.asyncAssertSuccess(ps -> {
            RowStream stream = ps.createStream(4, Tuple.tuple());
            ArrayList rows = new ArrayList();
            AtomicInteger ended = new AtomicInteger();
            stream.endHandler(v -> {
                ctx.assertEquals((Object)0, (Object)ended.getAndIncrement());
                ctx.assertEquals((Object)12, (Object)rows.size());
                async.complete();
            });
            stream.handler(tuple -> {
                ctx.assertEquals((Object)0, (Object)ended.get());
                rows.add(tuple);
            });
        }))))));
    }

    @Test
    public void testStreamQueryPauseInBatch(TestContext ctx) {
        this.testStreamQueryPauseInBatch(ctx, Runnable::run);
    }

    @Test
    public void testStreamQueryPauseInBatchFromAnotherThread(TestContext ctx) {
        this.testStreamQueryPauseInBatch(ctx, t -> new Thread(t).start());
    }

    private void testStreamQueryPauseInBatch(TestContext ctx, Executor executor) {
        Async async = ctx.async();
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("BEGIN", ctx.asyncAssertSuccess(begin -> conn.prepare("SELECT * FROM immutable", ctx.asyncAssertSuccess(ps -> {
            RowStream stream = ps.createStream(4, Tuple.tuple());
            List rows = Collections.synchronizedList(new ArrayList());
            AtomicInteger ended = new AtomicInteger();
            executor.execute(() -> {
                stream.endHandler(v -> {
                    ctx.assertEquals((Object)0, (Object)ended.getAndIncrement());
                    ctx.assertEquals((Object)12, (Object)rows.size());
                    async.complete();
                });
                stream.handler(tuple -> {
                    rows.add(tuple);
                    if (rows.size() == 2) {
                        stream.pause();
                        executor.execute(() -> this.vertx.setTimer(100L, v -> executor.execute(() -> ((RowStream)stream).resume())));
                    }
                });
            });
        }))))));
    }

    private void cleanTestTable(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("TRUNCATE TABLE mutable;", ctx.asyncAssertSuccess(result -> conn.close()))));
    }
}

