/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.tck.Connector;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class PreparedBatchTestBase {
    protected Vertx vertx;
    protected Connector<SqlConnection> connector;

    protected void connect(Handler<AsyncResult<SqlConnection>> handler) {
        this.connector.connect(handler);
    }

    protected abstract String statement(String ... var1);

    protected abstract void initConnector();

    @Before
    public void setUp(TestContext ctx) throws Exception {
        this.vertx = Vertx.vertx();
        this.initConnector();
        this.cleanTestTable(ctx);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.connector.close();
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testInsert(TestContext ctx) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {
            ArrayList<Tuple> batch = new ArrayList<Tuple>();
            batch.add(Tuple.of((Object)79991, (Object)"batch one"));
            batch.add(Tuple.of((Object)79992, (Object)"batch two"));
            batch.add(Tuple.of((Object)79993, (Object)"batch three"));
            batch.add(Tuple.of((Object)79994, (Object)"batch four"));
            conn.preparedBatch(this.statement("INSERT INTO mutable (id, val) VALUES (", ", ", ")"), batch, ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                conn.preparedQuery(this.statement("SELECT * FROM mutable WHERE id=", ""), Tuple.of((Object)79991), ctx.asyncAssertSuccess(ar1 -> {
                    ctx.assertEquals((Object)1, (Object)ar1.size());
                    Row one = ar1.iterator().next();
                    ctx.assertEquals((Object)79991, (Object)one.getInteger("id"));
                    ctx.assertEquals((Object)"batch one", (Object)one.getString("val"));
                    conn.preparedQuery(this.statement("SELECT * FROM mutable WHERE id=", ""), Tuple.of((Object)79992), ctx.asyncAssertSuccess(ar2 -> {
                        ctx.assertEquals((Object)1, (Object)ar2.size());
                        Row two = ar2.iterator().next();
                        ctx.assertEquals((Object)79992, (Object)two.getInteger("id"));
                        ctx.assertEquals((Object)"batch two", (Object)two.getString("val"));
                        conn.preparedQuery(this.statement("SELECT * FROM mutable WHERE id=", ""), Tuple.of((Object)79993), ctx.asyncAssertSuccess(ar3 -> {
                            ctx.assertEquals((Object)1, (Object)ar3.size());
                            Row three = ar3.iterator().next();
                            ctx.assertEquals((Object)79993, (Object)three.getInteger("id"));
                            ctx.assertEquals((Object)"batch three", (Object)three.getString("val"));
                            conn.preparedQuery(this.statement("SELECT * FROM mutable WHERE id=", ""), Tuple.of((Object)79994), ctx.asyncAssertSuccess(ar4 -> {
                                ctx.assertEquals((Object)1, (Object)ar4.size());
                                Row four = ar4.iterator().next();
                                ctx.assertEquals((Object)79994, (Object)four.getInteger("id"));
                                ctx.assertEquals((Object)"batch four", (Object)four.getString("val"));
                            }));
                        }));
                    }));
                }));
            }));
        }));
    }

    private void cleanTestTable(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("TRUNCATE TABLE mutable;", ctx.asyncAssertSuccess(result -> conn.close()))));
    }
}

