/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.tck.DataTypeTestBase;
import java.time.LocalDate;
import java.time.LocalTime;
import org.junit.Test;

public abstract class BinaryDataTypeEncodeTestBase
extends DataTypeTestBase {
    protected abstract String statement(String ... var1);

    @Test
    public void testSmallInt(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_int_2", Short.class, (short)Short.MIN_VALUE);
    }

    @Test
    public void testInteger(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_int_4", Integer.class, Integer.MIN_VALUE);
    }

    @Test
    public void testBigInt(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_int_8", Long.class, Long.MIN_VALUE);
    }

    @Test
    public void testFloat4(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_float_4", Float.class, Float.valueOf(-3.402823E38f));
    }

    @Test
    public void testDouble(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_float_8", Double.class, Double.MIN_VALUE);
    }

    @Test
    public void testNumeric(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_numeric", Numeric.class, Numeric.parse((String)"-999.99"));
    }

    @Test
    public void testDecimal(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_decimal", Numeric.class, Numeric.parse((String)"-12345"));
    }

    @Test
    public void testChar(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_char", String.class, "newchar0");
    }

    @Test
    public void testVarchar(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_varchar", String.class, "newvarchar");
    }

    @Test
    public void testBoolean(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_boolean", Boolean.class, false);
    }

    @Test
    public void testDate(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_date", LocalDate.class, LocalDate.parse("1999-12-31"));
    }

    @Test
    public void testTime(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_time", LocalTime.class, LocalTime.of(12, 1, 30));
    }

    protected <T> void testEncodeGeneric(TestContext ctx, String columnName, Class<T> clazz, T expected) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery(this.statement("UPDATE basicdatatype SET " + columnName + " = ", " WHERE id = 2"), Tuple.tuple().addValue(expected), ctx.asyncAssertSuccess(updateResult -> conn.preparedQuery("SELECT " + columnName + " FROM basicdatatype WHERE id = 2", ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = result.iterator().next();
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(columnName));
            conn.close();
        }))))));
    }
}

