/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.data;

import io.vertx.sqlclient.data.Numeric;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public class NumericTest {
    private Random random = new Random();
    private BigDecimal bigDecimalValue = new BigDecimal(new BigInteger(100, this.random), 50);
    private BigInteger bigIntegerValue = new BigInteger(100, this.random);
    private long longValue = this.random.nextLong();
    private short shortValue = (short)this.random.nextInt();
    private int intValue = this.random.nextInt();
    private double doubleValue = this.random.nextDouble();
    private float floatValue = this.random.nextFloat();

    @Test
    public void testCreate() {
        Assert.assertEquals((long)this.shortValue, (long)Numeric.create((Number)this.shortValue).shortValue());
        Assert.assertEquals((long)this.intValue, (long)Numeric.create((Number)this.intValue).intValue());
        Assert.assertEquals((long)this.longValue, (long)Numeric.create((Number)this.longValue).longValue());
        Assert.assertEquals((float)this.floatValue, (float)Numeric.create((Number)Float.valueOf(this.floatValue)).floatValue(), (float)0.01f);
        Assert.assertEquals((double)this.doubleValue, (double)Numeric.create((Number)this.doubleValue).doubleValue(), (double)0.01f);
        Assert.assertEquals((Object)this.bigIntegerValue, (Object)Numeric.create((Number)this.bigIntegerValue).bigIntegerValue());
        Assert.assertEquals((Object)this.bigDecimalValue, (Object)Numeric.create((Number)this.bigDecimalValue).bigDecimalValue());
    }

    @Test
    public void testParse() {
        Assert.assertEquals((Object)Numeric.NaN, (Object)Numeric.parse((String)"NaN"));
        Assert.assertEquals((Object)Numeric.create((Number)this.bigDecimalValue), (Object)Numeric.parse((String)this.bigDecimalValue.toString()));
        Assert.assertEquals((Object)Numeric.create((Number)this.bigIntegerValue), (Object)Numeric.parse((String)this.bigIntegerValue.toString()));
        Assert.assertEquals((Object)Numeric.create((Number)this.longValue), (Object)Numeric.parse((String)("" + this.longValue)));
        Assert.assertEquals((Object)Numeric.create((Number)this.shortValue), (Object)Numeric.parse((String)("" + this.shortValue)));
        Assert.assertEquals((Object)Numeric.create((Number)this.intValue), (Object)Numeric.parse((String)("" + this.intValue)));
        Assert.assertEquals((Object)Numeric.create((Number)Float.valueOf(this.floatValue)), (Object)Numeric.parse((String)("" + this.floatValue)));
        Assert.assertEquals((Object)Numeric.create((Number)this.doubleValue), (Object)Numeric.parse((String)("" + this.doubleValue)));
    }

    @Test
    public void testMethods() {
        Number[] numbers = new Number[]{Double.NaN, Double.NaN, Float.valueOf(Float.NaN), this.bigDecimalValue, this.bigIntegerValue, this.longValue, this.shortValue, this.intValue, this.doubleValue, Float.valueOf(this.floatValue)};
        Numeric[] test = new Numeric[]{Numeric.NaN, Numeric.create((Number)Double.NaN), Numeric.create((Number)Float.valueOf(Float.NaN)), Numeric.create((Number)this.bigDecimalValue), Numeric.create((Number)this.bigIntegerValue), Numeric.create((Number)this.longValue), Numeric.create((Number)this.shortValue), Numeric.create((Number)this.intValue), Numeric.create((Number)this.doubleValue), Numeric.create((Number)Float.valueOf(this.floatValue))};
        for (int i = 0; i < numbers.length; ++i) {
            Assert.assertEquals((Object)Double.isNaN(numbers[i].doubleValue()), (Object)test[i].isNaN());
            Assert.assertEquals((long)numbers[i].byteValue(), (long)test[i].byteValue());
            Assert.assertEquals((long)numbers[i].intValue(), (long)test[i].intValue());
            Assert.assertEquals((long)numbers[i].shortValue(), (long)test[i].shortValue());
            Assert.assertEquals((long)numbers[i].longValue(), (long)test[i].longValue());
            Assert.assertEquals((float)numbers[i].floatValue(), (float)test[i].floatValue(), (float)0.01f);
            Assert.assertEquals((double)numbers[i].doubleValue(), (double)test[i].doubleValue(), (double)0.01);
            Assert.assertEquals((Object)Numeric.create((Number)numbers[i]), (Object)test[i]);
            Assert.assertEquals((Object)test[i], (Object)Numeric.create((Number)numbers[i]));
            Assert.assertEquals((Object)numbers[i].toString(), (Object)test[i].toString());
        }
    }

    @Test
    public void testFormatException() {
        Consumer<Runnable> checker = r -> {
            try {
                r.run();
                Assert.fail();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        };
        for (Number number : Arrays.asList(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY))) {
            checker.accept(() -> Numeric.create((Number)number));
        }
        checker.accept(() -> Numeric.parse((String)"foobar"));
    }

    @Test
    public void testNull() {
        Function<Number, Numeric> f1 = Numeric::create;
        Function<String, Numeric> f2 = Numeric::parse;
        for (Function c : Arrays.asList(f1, f2)) {
            try {
                c.apply(null);
                Assert.fail();
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        Numeric[] numerics;
        int intValue = this.random.nextInt(1000);
        for (Numeric l : numerics = new Numeric[]{Numeric.create((Number)intValue), Numeric.create((Number)((short)intValue)), Numeric.create((Number)intValue), Numeric.create((Number)intValue), Numeric.create((Number)Float.valueOf(intValue)), Numeric.create((Number)new BigInteger("" + intValue)), Numeric.create((Number)new BigDecimal("" + intValue))}) {
            for (Numeric r : numerics) {
                Assert.assertEquals((Object)l, (Object)r);
                Assert.assertEquals((long)l.hashCode(), (long)r.hashCode());
            }
        }
        Assert.assertEquals((Object)Numeric.create((Number)Double.NaN), (Object)Numeric.create((Number)Float.valueOf(Float.NaN)));
        for (Numeric l : numerics) {
            Assert.assertNotSame((Object)Numeric.NaN, (Object)l);
            Assert.assertNotSame((Object)l, (Object)Numeric.NaN);
            Assert.assertNotSame((Object)Numeric.create((Number)Float.valueOf(Float.NaN)), (Object)l);
            Assert.assertNotSame((Object)l, (Object)Numeric.create((Number)Float.valueOf(Float.NaN)));
            Assert.assertNotSame((Object)Numeric.create((Number)Double.NaN), (Object)l);
            Assert.assertNotSame((Object)l, (Object)Numeric.create((Number)Double.NaN));
        }
    }

    private static int len(int size) {
        int d = (int)((double)size * Math.log(10000.0) / Math.log(2.0));
        return d;
    }

    @Test
    public void testFoo() {
    }
}

