/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.redis.client;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.MaybeHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.streams.Pipe;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.redis.client.RedisConnection.class)
public class RedisConnection
implements RxDelegate,
ReadStream<Response> {
    public static final TypeArg<RedisConnection> __TYPE_ARG = new TypeArg(obj -> new RedisConnection((io.vertx.redis.client.RedisConnection)obj), RedisConnection::getDelegate);
    private final io.vertx.redis.client.RedisConnection delegate;
    private Observable<Response> observable;
    private Flowable<Response> flowable;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisConnection that = (RedisConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RedisConnection(io.vertx.redis.client.RedisConnection delegate) {
        this.delegate = delegate;
    }

    public RedisConnection(Object delegate) {
        this.delegate = (io.vertx.redis.client.RedisConnection)delegate;
    }

    public io.vertx.redis.client.RedisConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Response> toObservable() {
        if (this.observable == null) {
            this.observable = ObservableHelper.toObservable((io.vertx.core.streams.ReadStream)this.getDelegate());
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<Response> toFlowable() {
        if (this.flowable == null) {
            this.flowable = FlowableHelper.toFlowable((io.vertx.core.streams.ReadStream)this.getDelegate());
        }
        return this.flowable;
    }

    @Override
    public Pipe<Response> pipe() {
        Pipe<Response> ret = Pipe.newInstance(this.delegate.pipe(), TypeArg.unknown());
        return ret;
    }

    @Override
    public Completable pipeTo(WriteStream<Response> dst) {
        Completable ret = this.rxPipeTo(dst);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<Response> dst) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.pipeTo(dst.getDelegate()));
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public RedisConnection handler(Handler<Response> handler) {
        this.delegate.handler(handler);
        return this;
    }

    public RedisConnection pause() {
        this.delegate.pause();
        return this;
    }

    public RedisConnection resume() {
        this.delegate.resume();
        return this;
    }

    public RedisConnection fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public RedisConnection endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public Maybe<Response> send(Request command) {
        Maybe ret = this.rxSend(command);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<Response> rxSend(Request command) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.send(command), __value -> __value);
    }

    public Single<List<Response>> batch(List<Request> commands) {
        Single ret = this.rxBatch(commands);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<Response>> rxBatch(List<Request> commands) {
        return AsyncResultSingle.toSingle(() -> this.delegate.batch(commands), __value -> __value);
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public boolean pendingQueueFull() {
        boolean ret = this.delegate.pendingQueueFull();
        return ret;
    }

    public static RedisConnection newInstance(io.vertx.redis.client.RedisConnection arg) {
        return arg != null ? new RedisConnection(arg) : null;
    }
}

