/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.net;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.ConnectOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.metrics.Measured;
import io.vertx.rxjava3.core.net.NetSocket;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.concurrent.TimeUnit;

@RxGen(value=io.vertx.core.net.NetClient.class)
public class NetClient
implements Measured {
    public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg(obj -> new NetClient((io.vertx.core.net.NetClient)obj), NetClient::getDelegate);
    private final io.vertx.core.net.NetClient delegate;
    private static final TypeArg<NetSocket> TYPE_ARG_0 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<NetSocket> TYPE_ARG_1 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<NetSocket> TYPE_ARG_2 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<NetSocket> TYPE_ARG_3 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<NetSocket> TYPE_ARG_4 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetClient that = (NetClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetClient(io.vertx.core.net.NetClient delegate) {
        this.delegate = delegate;
    }

    public NetClient(Object delegate) {
        this.delegate = (io.vertx.core.net.NetClient)delegate;
    }

    public io.vertx.core.net.NetClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public Single<NetSocket> connect(int port, String host) {
        Single ret = this.rxConnect(port, host);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetSocket> rxConnect(int port, String host) {
        return AsyncResultSingle.toSingle(() -> this.delegate.connect(port, host), __value -> NetSocket.newInstance(__value));
    }

    public Single<NetSocket> connect(int port, String host, String serverName) {
        Single ret = this.rxConnect(port, host, serverName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetSocket> rxConnect(int port, String host, String serverName) {
        return AsyncResultSingle.toSingle(() -> this.delegate.connect(port, host, serverName), __value -> NetSocket.newInstance(__value));
    }

    public Single<NetSocket> connect(SocketAddress remoteAddress) {
        Single ret = this.rxConnect(remoteAddress);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress) {
        return AsyncResultSingle.toSingle(() -> this.delegate.connect(remoteAddress), __value -> NetSocket.newInstance(__value));
    }

    public Single<NetSocket> connect(SocketAddress remoteAddress, String serverName) {
        Single ret = this.rxConnect(remoteAddress, serverName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress, String serverName) {
        return AsyncResultSingle.toSingle(() -> this.delegate.connect(remoteAddress, serverName), __value -> NetSocket.newInstance(__value));
    }

    public Single<NetSocket> connect(ConnectOptions connectOptions) {
        Single ret = this.rxConnect(connectOptions);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetSocket> rxConnect(ConnectOptions connectOptions) {
        return AsyncResultSingle.toSingle(() -> this.delegate.connect(connectOptions), __value -> NetSocket.newInstance(__value));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public Completable shutdown() {
        Completable ret = this.rxShutdown();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxShutdown() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown());
    }

    public Completable shutdown(long timeout, TimeUnit unit) {
        Completable ret = this.rxShutdown(timeout, unit);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxShutdown(long timeout, TimeUnit unit) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown(timeout, unit));
    }

    public Single<Boolean> updateSSLOptions(ClientSSLOptions options) {
        Single ret = this.rxUpdateSSLOptions(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ClientSSLOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.updateSSLOptions(options), __value -> __value);
    }

    public Single<Boolean> updateSSLOptions(ClientSSLOptions options, boolean force) {
        Single ret = this.rxUpdateSSLOptions(options, force);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ClientSSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle(() -> this.delegate.updateSSLOptions(options, force), __value -> __value);
    }

    public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
        return arg != null ? new NetClient(arg) : null;
    }
}

