/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.http;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import io.vertx.rxjava3.core.MultiMap;
import io.vertx.rxjava3.core.http.HttpClientResponse;
import io.vertx.rxjava3.core.http.HttpConnection;
import io.vertx.rxjava3.core.http.HttpFrame;
import io.vertx.rxjava3.core.net.HostAndPort;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.ReadStreamSubscriber;
import java.util.function.Function;

@RxGen(value=io.vertx.core.http.HttpClientRequest.class)
public class HttpClientRequest
implements WriteStream<io.vertx.rxjava3.core.buffer.Buffer> {
    public static final TypeArg<HttpClientRequest> __TYPE_ARG = new TypeArg(obj -> new HttpClientRequest((io.vertx.core.http.HttpClientRequest)obj), HttpClientRequest::getDelegate);
    private final io.vertx.core.http.HttpClientRequest delegate;
    private WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> subscriber;
    private MultiMap cached_0;
    private HttpConnection cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientRequest that = (HttpClientRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClientRequest(io.vertx.core.http.HttpClientRequest delegate) {
        this.delegate = delegate;
    }

    public HttpClientRequest(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClientRequest)delegate;
    }

    public io.vertx.core.http.HttpClientRequest getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Completable write(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWrite(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write((Object)data.getDelegate(), handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpClientRequest drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public HttpClientRequest authority(HostAndPort authority) {
        this.delegate.authority(authority.getDelegate());
        return this;
    }

    @Deprecated
    public HttpClientRequest setHost(String host) {
        this.delegate.setHost(host);
        return this;
    }

    @Deprecated
    public String getHost() {
        String ret = this.delegate.getHost();
        return ret;
    }

    @Deprecated
    public HttpClientRequest setPort(int port) {
        this.delegate.setPort(port);
        return this;
    }

    @Deprecated
    public int getPort() {
        int ret = this.delegate.getPort();
        return ret;
    }

    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.delegate.setFollowRedirects(followRedirects);
        return this;
    }

    public boolean isFollowRedirects() {
        boolean ret = this.delegate.isFollowRedirects();
        return ret;
    }

    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        this.delegate.setMaxRedirects(maxRedirects);
        return this;
    }

    public int getMaxRedirects() {
        int ret = this.delegate.getMaxRedirects();
        return ret;
    }

    public int numberOfRedirections() {
        int ret = this.delegate.numberOfRedirections();
        return ret;
    }

    public HttpClientRequest setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public HttpMethod getMethod() {
        HttpMethod ret = this.delegate.getMethod();
        return ret;
    }

    public HttpClientRequest setMethod(HttpMethod method) {
        this.delegate.setMethod(method);
        return this;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public String getURI() {
        String ret = this.delegate.getURI();
        return ret;
    }

    public HttpClientRequest setURI(String uri) {
        this.delegate.setURI(uri);
        return this;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpClientRequest putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest traceOperation(String op) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.traceOperation(op));
        return ret;
    }

    public String traceOperation() {
        String ret = this.delegate.traceOperation();
        return ret;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    @Override
    public Completable write(String chunk) {
        Completable ret = this.rxWrite(chunk);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(String chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write(chunk, handler));
    }

    public Completable write(String chunk, String enc) {
        Completable ret = this.rxWrite(chunk, enc);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWrite(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write(chunk, enc, handler));
    }

    public HttpClientRequest continueHandler(Handler<Void> handler) {
        this.delegate.continueHandler(handler);
        return this;
    }

    public HttpClientRequest earlyHintsHandler(Handler<MultiMap> handler) {
        this.delegate.earlyHintsHandler((Handler)new DelegatingHandler(handler, event -> MultiMap.newInstance(event)));
        return this;
    }

    public HttpClientRequest redirectHandler(final Function<HttpClientResponse, Single<HttpClientRequest>> handler) {
        this.delegate.redirectHandler((Function)new Function<io.vertx.core.http.HttpClientResponse, Future<io.vertx.core.http.HttpClientRequest>>(){

            @Override
            public Future<io.vertx.core.http.HttpClientRequest> apply(io.vertx.core.http.HttpClientResponse arg) {
                Single ret = (Single)handler.apply(HttpClientResponse.newInstance(arg));
                return SingleHelper.toFuture((Single)ret, obj -> obj.getDelegate());
            }
        });
        return this;
    }

    public Completable sendHead() {
        Completable ret = this.rxSendHead();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendHead() {
        return AsyncResultCompletable.toCompletable(completionHandler -> this.delegate.sendHead(completionHandler));
    }

    public Single<HttpClientResponse> connect() {
        Single ret = this.rxConnect();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpClientResponse> rxConnect() {
        return AsyncResultSingle.toSingle(handler -> this.delegate.connect((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event)))));
    }

    public Single<HttpClientResponse> response() {
        Single ret = this.rxResponse();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpClientResponse> rxResponse() {
        return AsyncResultSingle.toSingle(handler -> this.delegate.response((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event)))));
    }

    public Single<HttpClientResponse> send() {
        Single ret = this.rxSend();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpClientResponse> rxSend() {
        return AsyncResultSingle.toSingle(handler -> this.delegate.send((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event)))));
    }

    public Single<HttpClientResponse> send(String body) {
        Single ret = this.rxSend(body);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpClientResponse> rxSend(String body) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.send(body, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event)))));
    }

    public Single<HttpClientResponse> send(io.vertx.rxjava3.core.buffer.Buffer body) {
        Single ret = this.rxSend(body);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpClientResponse> rxSend(io.vertx.rxjava3.core.buffer.Buffer body) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.send(body.getDelegate(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event)))));
    }

    public Single<HttpClientResponse> send(Flowable<io.vertx.rxjava3.core.buffer.Buffer> body) {
        Single ret = this.rxSend(body);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpClientResponse> rxSend(Flowable<io.vertx.rxjava3.core.buffer.Buffer> body) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.send(ReadStreamSubscriber.asReadStream((Flowable)body, obj -> obj.getDelegate()).resume(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event)))));
    }

    @Override
    public Completable end(String chunk) {
        Completable ret = this.rxEnd(chunk);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(String chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(chunk, handler));
    }

    public Completable end(String chunk, String enc) {
        Completable ret = this.rxEnd(chunk, enc);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxEnd(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(chunk, enc, handler));
    }

    @Override
    public Completable end(io.vertx.rxjava3.core.buffer.Buffer chunk) {
        Completable ret = this.rxEnd(chunk);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(io.vertx.rxjava3.core.buffer.Buffer chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(chunk.getDelegate(), handler));
    }

    @Override
    public Completable end() {
        Completable ret = this.rxEnd();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(handler));
    }

    @Deprecated
    public HttpClientRequest setTimeout(long timeout) {
        this.delegate.setTimeout(timeout);
        return this;
    }

    public HttpClientRequest idleTimeout(long timeout) {
        this.delegate.idleTimeout(timeout);
        return this;
    }

    public HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        this.delegate.pushHandler((Handler)new DelegatingHandler(handler, event -> HttpClientRequest.newInstance(event)));
        return this;
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public boolean reset(long code, Throwable cause) {
        boolean ret = this.delegate.reset(code, cause);
        return ret;
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public HttpClientRequest writeCustomFrame(int type, int flags, io.vertx.rxjava3.core.buffer.Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, payload.getDelegate());
        return this;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public StreamPriority getStreamPriority() {
        StreamPriority ret = this.delegate.getStreamPriority();
        return ret;
    }

    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public static HttpClientRequest newInstance(io.vertx.core.http.HttpClientRequest arg) {
        return arg != null ? new HttpClientRequest(arg) : null;
    }
}

