/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.db2client;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.sqlclient.PreparedStatement;
import io.vertx.rxjava3.sqlclient.SqlConnection;

@RxGen(value=io.vertx.db2client.DB2Connection.class)
public class DB2Connection
extends SqlConnection
implements RxDelegate {
    public static final TypeArg<DB2Connection> __TYPE_ARG = new TypeArg(obj -> new DB2Connection((io.vertx.db2client.DB2Connection)obj), DB2Connection::getDelegate);
    private final io.vertx.db2client.DB2Connection delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DB2Connection that = (DB2Connection)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DB2Connection(io.vertx.db2client.DB2Connection delegate) {
        super((io.vertx.sqlclient.SqlConnection)delegate);
        this.delegate = delegate;
    }

    public DB2Connection(Object delegate) {
        super((io.vertx.sqlclient.SqlConnection)((io.vertx.db2client.DB2Connection)delegate));
        this.delegate = (io.vertx.db2client.DB2Connection)delegate;
    }

    public io.vertx.db2client.DB2Connection getDelegate() {
        return this.delegate;
    }

    public static Single<DB2Connection> connect(io.vertx.rxjava3.core.Vertx vertx, DB2ConnectOptions connectOptions) {
        Single ret = DB2Connection.rxConnect(vertx, connectOptions);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public static Single<DB2Connection> rxConnect(io.vertx.rxjava3.core.Vertx vertx, DB2ConnectOptions connectOptions) {
        return AsyncResultSingle.toSingle(handler -> io.vertx.db2client.DB2Connection.connect((Vertx)vertx.getDelegate(), (DB2ConnectOptions)connectOptions, (Handler)Helper.convertHandler((Handler)handler, ar -> ar.map(event -> DB2Connection.newInstance(event)))));
    }

    public static Single<DB2Connection> connect(io.vertx.rxjava3.core.Vertx vertx, String connectionUri) {
        Single ret = DB2Connection.rxConnect(vertx, connectionUri);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public static Single<DB2Connection> rxConnect(io.vertx.rxjava3.core.Vertx vertx, String connectionUri) {
        return AsyncResultSingle.toSingle(handler -> io.vertx.db2client.DB2Connection.connect((Vertx)vertx.getDelegate(), (String)connectionUri, (Handler)Helper.convertHandler((Handler)handler, ar -> ar.map(event -> DB2Connection.newInstance(event)))));
    }

    @Override
    public Single<PreparedStatement> prepare(String sql) {
        Single ret = this.rxPrepare(sql);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    @Override
    public Single<PreparedStatement> rxPrepare(String sql) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.prepare(sql, Helper.convertHandler((Handler)handler, ar -> ar.map(event -> PreparedStatement.newInstance(event)))));
    }

    @Override
    public DB2Connection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public DB2Connection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public Completable ping() {
        Completable ret = this.rxPing();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxPing() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.ping(handler));
    }

    public Completable debug() {
        Completable ret = this.rxDebug();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDebug() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.debug(handler));
    }

    public static DB2Connection cast(SqlConnection sqlConnection) {
        DB2Connection ret = DB2Connection.newInstance(io.vertx.db2client.DB2Connection.cast((io.vertx.sqlclient.SqlConnection)sqlConnection.getDelegate()));
        return ret;
    }

    public static DB2Connection newInstance(io.vertx.db2client.DB2Connection arg) {
        return arg != null ? new DB2Connection(arg) : null;
    }
}

