/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.pgclient.pubsub;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A class for managing subscriptions using <code>LISTEN/UNLISTEN</code> to Postgres channels.
 * <p/>
 * The subscriber manages a single connection to Postgres.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.pubsub.PgSubscriber original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.pgclient.pubsub.PgSubscriber.class)
public class PgSubscriber implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgSubscriber that = (PgSubscriber) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PgSubscriber> __TYPE_ARG = new TypeArg<>(    obj -> new PgSubscriber((io.vertx.pgclient.pubsub.PgSubscriber) obj),
    PgSubscriber::getDelegate
  );

  private final io.vertx.pgclient.pubsub.PgSubscriber delegate;
  
  public PgSubscriber(io.vertx.pgclient.pubsub.PgSubscriber delegate) {
    this.delegate = delegate;
  }

  public PgSubscriber(Object delegate) {
    this.delegate = (io.vertx.pgclient.pubsub.PgSubscriber)delegate;
  }

  @Override 
  public io.vertx.pgclient.pubsub.PgSubscriber getDelegate() {
    return delegate;
  }

  /**
   * Create a subscriber.
   * @param vertx the vertx instance
   * @param options the connect options
   * @return the subscriber
   */
  public static io.vertx.rxjava3.pgclient.pubsub.PgSubscriber subscriber(io.vertx.rxjava3.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions options) { 
    io.vertx.rxjava3.pgclient.pubsub.PgSubscriber ret = io.vertx.rxjava3.pgclient.pubsub.PgSubscriber.newInstance((io.vertx.pgclient.pubsub.PgSubscriber)io.vertx.pgclient.pubsub.PgSubscriber.subscriber(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Return a channel for the given <code>name</code>.
   * @param name the channel name <p/> This will be the name of the channel exactly as held by Postgres for sending notifications. Internally this name will be truncated to the Postgres identifier maxiumum length of <code>(NAMEDATALEN = 64) - 1 == 63</code> characters, and prepared as a quoted identifier without unicode escape sequence support for use in <code>LISTEN/UNLISTEN</code> commands. Examples of channel names and corresponding <code>NOTIFY</code> commands: <ul> <li>when <code>name == "the_channel"</code>: <code>NOTIFY the_channel, 'msg'</code>, <code>NOTIFY The_Channel, 'msg'</code>, or <code>NOTIFY "the_channel", 'msg'</code> succeed in delivering a message to the created channel </li> <li>when <code>name == "The_Channel"</code>: <code>NOTIFY "The_Channel", 'msg'</code>, succeeds in delivering a message to the created channel </li> <li></li> </ul>
   * @return the channel
   */
  public io.vertx.rxjava3.pgclient.pubsub.PgChannel channel(java.lang.String name) { 
    io.vertx.rxjava3.pgclient.pubsub.PgChannel ret = io.vertx.rxjava3.pgclient.pubsub.PgChannel.newInstance((io.vertx.pgclient.pubsub.PgChannel)delegate.channel(name));
    return ret;
  }

  /**
   * Connect the subscriber to Postgres.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable connect() { 
    io.reactivex.rxjava3.core.Completable ret = rxConnect();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Connect the subscriber to Postgres.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable rxConnect() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.connect(handler);
    });
  }

  /**
   * Set the reconnect policy that is executed when the subscriber is disconnected.
   * <p/>
   * When the subscriber is disconnected, the <code>policy</code> function is called with the actual
   * number of retries and returns an <code>amountOfTime</code> value:
   * <ul>
   *   <li>when <code>amountOfTime < 0</code>: the subscriber is closed and there is no retry</li>
   *   <li>when <code>amountOfTime == 0</code>: the subscriber retries to connect immediately</li>
   *   <li>when <code>amountOfTime > 0</code>: the subscriber retries after <code>amountOfTime</code> milliseconds</li>
   * </ul>
   * <p/>
   * The default policy does not perform any retries.
   * @param policy the policy to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.pgclient.pubsub.PgSubscriber reconnectPolicy(java.util.function.Function<java.lang.Integer,java.lang.Long> policy) { 
    delegate.reconnectPolicy(policy);
    return this;
  }

  /**
   * Set an handler called when the subscriber is closed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.pgclient.pubsub.PgSubscriber closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @return the actual connection to Postgres, it might be <code>null</code>
   */
  public io.vertx.rxjava3.pgclient.PgConnection actualConnection() { 
    io.vertx.rxjava3.pgclient.PgConnection ret = io.vertx.rxjava3.pgclient.PgConnection.newInstance((io.vertx.pgclient.PgConnection)delegate.actualConnection());
    return ret;
  }

  /**
   * @return whether the subscriber is closed
   */
  public boolean closed() { 
    boolean ret = delegate.closed();
    return ret;
  }

  /**
   * Close the subscriber, the retry policy will not be invoked.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the subscriber, the retry policy will not be invoked.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.close(handler);
    });
  }

  public static PgSubscriber newInstance(io.vertx.pgclient.pubsub.PgSubscriber arg) {
    return arg != null ? new PgSubscriber(arg) : null;
  }

}
