/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.openapi.validation;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.openapi.validation.ValidatableRequest.class)
public class ValidatableRequest extends io.vertx.rxjava3.openapi.validation.ValidatedRequest implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValidatableRequest that = (ValidatableRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ValidatableRequest> __TYPE_ARG = new TypeArg<>(    obj -> new ValidatableRequest((io.vertx.openapi.validation.ValidatableRequest) obj),
    ValidatableRequest::getDelegate
  );

  private final io.vertx.openapi.validation.ValidatableRequest delegate;
  
  public ValidatableRequest(io.vertx.openapi.validation.ValidatableRequest delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ValidatableRequest(Object delegate) {
    super((io.vertx.openapi.validation.ValidatableRequest)delegate);
    this.delegate = (io.vertx.openapi.validation.ValidatableRequest)delegate;
  }

  @Override 
  public io.vertx.openapi.validation.ValidatableRequest getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.openapi.validation.ValidatableRequest> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.openapi.validation.ValidatableRequest>(o1 -> io.vertx.rxjava3.openapi.validation.ValidatableRequest.newInstance((io.vertx.openapi.validation.ValidatableRequest)o1), o1 -> o1.getDelegate());

  /**
   * Creates a new {@link io.vertx.rxjava3.openapi.validation.ValidatableRequest} object based on the passed  and .
   * @param request The related request
   * @param operation The related operation
   * @return a {@link io.vertx.rxjava3.openapi.validation.ValidatableRequest} object
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.openapi.validation.ValidatableRequest> of(io.vertx.rxjava3.core.http.HttpServerRequest request, io.vertx.rxjava3.openapi.contract.Operation operation) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.openapi.validation.ValidatableRequest> ret = rxOf(request, operation);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Creates a new {@link io.vertx.rxjava3.openapi.validation.ValidatableRequest} object based on the passed  and .
   * @param request The related request
   * @param operation The related operation
   * @return a {@link io.vertx.rxjava3.openapi.validation.ValidatableRequest} object
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.openapi.validation.ValidatableRequest> rxOf(io.vertx.rxjava3.core.http.HttpServerRequest request, io.vertx.rxjava3.openapi.contract.Operation operation) { 
    return AsyncResultSingle.toSingle(io.vertx.openapi.validation.ValidatableRequest.of(request.getDelegate(), operation.getDelegate()), __value -> io.vertx.rxjava3.openapi.validation.ValidatableRequest.newInstance((io.vertx.openapi.validation.ValidatableRequest)__value));
  }

  public java.lang.String getContentType() { 
    java.lang.String ret = delegate.getContentType();
    return ret;
  }

  public static ValidatableRequest newInstance(io.vertx.openapi.validation.ValidatableRequest arg) {
    return arg != null ? new ValidatableRequest(arg) : null;
  }

}
