/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.mqtt.messages;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an MQTT PUBLISH message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttPublishMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.messages.MqttPublishMessage.class)
public class MqttPublishMessage implements RxDelegate, io.vertx.rxjava3.mqtt.messages.MqttMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttPublishMessage that = (MqttPublishMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttPublishMessage> __TYPE_ARG = new TypeArg<>(    obj -> new MqttPublishMessage((io.vertx.mqtt.messages.MqttPublishMessage) obj),
    MqttPublishMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttPublishMessage delegate;
  
  public MqttPublishMessage(io.vertx.mqtt.messages.MqttPublishMessage delegate) {
    this.delegate = delegate;
  }

  public MqttPublishMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttPublishMessage)delegate;
  }

  @Override 
  public io.vertx.mqtt.messages.MqttPublishMessage getDelegate() {
    return delegate;
  }

  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return Quality of service level
   */
  public io.netty.handler.codec.mqtt.MqttQoS qosLevel() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.netty.handler.codec.mqtt.MqttQoS ret = delegate.qosLevel();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return If the message is a duplicate
   */
  public boolean isDup() { 
    if (cached_2 != null) {
      return cached_2;
    }
    boolean ret = delegate.isDup();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return If the message needs to be retained
   */
  public boolean isRetain() { 
    if (cached_3 != null) {
      return cached_3;
    }
    boolean ret = delegate.isRetain();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return Topic on which the message was published
   */
  public java.lang.String topicName() { 
    if (cached_4 != null) {
      return cached_4;
    }
    java.lang.String ret = delegate.topicName();
    cached_4 = ret;
    return ret;
  }

  /**
   * @return Payload message
   */
  public io.vertx.rxjava3.core.buffer.Buffer payload() { 
    if (cached_5 != null) {
      return cached_5;
    }
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.payload());
    cached_5 = ret;
    return ret;
  }

  /**
   * Send the PUBACK/PUBCOMP to the broker. Use this method only if autoAck option is set to false.
   */
  public void ack() { 
    delegate.ack();
  }

  /**
   * Create a concrete instance of a Vert.x publish message
   * @param messageId message identifier
   * @param qosLevel quality of service level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param topicName topic on which the message was published
   * @param payload payload message
   * @param properties message properties
   * @return Vert.x publish message
   */
  public static io.vertx.rxjava3.mqtt.messages.MqttPublishMessage create(int messageId, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, java.lang.String topicName, io.netty.buffer.ByteBuf payload, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.rxjava3.mqtt.messages.MqttPublishMessage ret = io.vertx.rxjava3.mqtt.messages.MqttPublishMessage.newInstance((io.vertx.mqtt.messages.MqttPublishMessage)io.vertx.mqtt.messages.MqttPublishMessage.create(messageId, qosLevel, isDup, isRetain, topicName, payload, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_6 != null) {
      return cached_6;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_6 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private io.netty.handler.codec.mqtt.MqttQoS cached_1;
  private java.lang.Boolean cached_2;
  private java.lang.Boolean cached_3;
  private java.lang.String cached_4;
  private io.vertx.rxjava3.core.buffer.Buffer cached_5;
  private io.netty.handler.codec.mqtt.MqttProperties cached_6;
  public static MqttPublishMessage newInstance(io.vertx.mqtt.messages.MqttPublishMessage arg) {
    return arg != null ? new MqttPublishMessage(arg) : null;
  }

}
