/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.grpc.server;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.grpc.server.GrpcServerRequest.class)
public class GrpcServerRequest<Req,Resp> extends io.vertx.rxjava3.grpc.common.GrpcReadStream<Req> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcServerRequest that = (GrpcServerRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcServerRequest> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcServerRequest((io.vertx.grpc.server.GrpcServerRequest) obj),
    GrpcServerRequest::getDelegate
  );

  private final io.vertx.grpc.server.GrpcServerRequest<Req,Resp> delegate;
  public final TypeArg<Req> __typeArg_0;
  public final TypeArg<Resp> __typeArg_1;
  
  public GrpcServerRequest(io.vertx.grpc.server.GrpcServerRequest delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public GrpcServerRequest(Object delegate, TypeArg<Req> typeArg_0, TypeArg<Resp> typeArg_1) {
    super((io.vertx.grpc.server.GrpcServerRequest)delegate);
    this.delegate = (io.vertx.grpc.server.GrpcServerRequest)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  @Override 
  public io.vertx.grpc.server.GrpcServerRequest getDelegate() {
    return delegate;
  }

  private io.reactivex.rxjava3.core.Observable<Req> observable;
  private io.reactivex.rxjava3.core.Flowable<Req> flowable;

  public synchronized io.reactivex.rxjava3.core.Observable<Req> toObservable() {
    if (observable == null) {
      Function<Req, Req> conv = (Function<Req, Req>) __typeArg_0.wrap;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.rxjava3.core.Flowable<Req> toFlowable() {
    if (flowable == null) {
      Function<Req, Req> conv = (Function<Req, Req>) __typeArg_0.wrap;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava3.core.streams.Pipe<Req> pipe() { 
    io.vertx.rxjava3.core.streams.Pipe<Req> ret = io.vertx.rxjava3.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), __typeArg_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable pipeTo(io.vertx.rxjava3.core.streams.WriteStream<Req> dst) { 
    io.reactivex.rxjava3.core.Completable ret = rxPipeTo(dst);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxPipeTo(io.vertx.rxjava3.core.streams.WriteStream<Req> dst) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * @return the last element of the stream
   */
  public io.reactivex.rxjava3.core.Single<Req> last() { 
    io.reactivex.rxjava3.core.Single<Req> ret = rxLast();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * @return the last element of the stream
   */
  public io.reactivex.rxjava3.core.Single<Req> rxLast() { 
    return AsyncResultSingle.toSingle(delegate.last(), __value -> (Req)__typeArg_0.wrap(__value));
  }

  /**
   * @return the service name
   */
  public io.vertx.rxjava3.grpc.common.ServiceName serviceName() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava3.grpc.common.ServiceName ret = io.vertx.rxjava3.grpc.common.ServiceName.newInstance((io.vertx.grpc.common.ServiceName)delegate.serviceName());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the method name
   */
  public java.lang.String methodName() { 
    if (cached_1 != null) {
      return cached_1;
    }
    java.lang.String ret = delegate.methodName();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the full method name sent by the client
   */
  public java.lang.String fullMethodName() { 
    if (cached_2 != null) {
      return cached_2;
    }
    java.lang.String ret = delegate.fullMethodName();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return the response
   */
  public io.vertx.rxjava3.grpc.server.GrpcServerResponse<Req,Resp> response() { 
    if (cached_3 != null) {
      return cached_3;
    }
    io.vertx.rxjava3.grpc.server.GrpcServerResponse<Req,Resp> ret = io.vertx.rxjava3.grpc.server.GrpcServerResponse.newInstance((io.vertx.grpc.server.GrpcServerResponse)delegate.response(), __typeArg_0, __typeArg_1);
    cached_3 = ret;
    return ret;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerRequest<Req,Resp> messageHandler(io.vertx.core.Handler<io.vertx.rxjava3.grpc.common.GrpcMessage> handler) { 
    delegate.messageHandler(io.vertx.lang.rxjava3.Helper.convertHandler(handler, event -> io.vertx.rxjava3.grpc.common.GrpcMessage.newInstance((io.vertx.grpc.common.GrpcMessage)event)));
    return this;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerRequest<Req,Resp> errorHandler(io.vertx.core.Handler<io.vertx.grpc.common.GrpcError> handler) { 
    delegate.errorHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerRequest<Req,Resp> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerRequest<Req,Resp> handler(io.vertx.core.Handler<Req> handler) { 
    delegate.handler(io.vertx.lang.rxjava3.Helper.convertHandler(handler, event -> (Req)__typeArg_0.wrap(event)));
    return this;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerRequest<Req,Resp> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerRequest<Req,Resp> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerRequest<Req,Resp> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava3.grpc.server.GrpcServerRequest<Req,Resp> endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @return the underlying HTTP connection
   */
  public io.vertx.rxjava3.core.http.HttpConnection connection() { 
    io.vertx.rxjava3.core.http.HttpConnection ret = io.vertx.rxjava3.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)delegate.connection());
    return ret;
  }

  /**
   * Set a message handler that is reported with invalid message errors.
   *
   * <p>Warning: setting this handler overwrite the default handler which takes appropriate measure
   * when an invalid message is encountered such as cancelling the stream. This handler should be set
   * when control over invalid messages is required.</p>
   * @param handler the invalid message handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.grpc.common.GrpcReadStream<Req> invalidMessageHandler(io.vertx.core.Handler<io.vertx.grpc.common.InvalidMessageException> handler) { 
    io.vertx.rxjava3.grpc.common.GrpcReadStream<Req> ret = io.vertx.rxjava3.grpc.common.GrpcReadStream.newInstance((io.vertx.grpc.common.GrpcReadStream)delegate.invalidMessageHandler(handler), __typeArg_0);
    return ret;
  }

  /**
   * @param collector 
   * @return the result of applying a collector on the stream
   */
  @Deprecated()
  public <R, A> io.reactivex.rxjava3.core.Single<R> collecting(java.util.stream.Collector<Req,A,R> collector) { 
    io.reactivex.rxjava3.core.Single<R> ret = rxCollecting(collector);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * @param collector 
   * @return the result of applying a collector on the stream
   */
  @Deprecated()
  public <R, A> io.reactivex.rxjava3.core.Single<R> rxCollecting(java.util.stream.Collector<Req,A,R> collector) { 
    return AsyncResultSingle.toSingle(delegate.collecting(collector), __value -> (R) __value);
  }

  private io.vertx.rxjava3.grpc.common.ServiceName cached_0;
  private java.lang.String cached_1;
  private java.lang.String cached_2;
  private io.vertx.rxjava3.grpc.server.GrpcServerResponse<Req,Resp> cached_3;
  public static <Req,Resp> GrpcServerRequest<Req,Resp> newInstance(io.vertx.grpc.server.GrpcServerRequest arg) {
    return arg != null ? new GrpcServerRequest<Req,Resp>(arg) : null;
  }

  public static <Req,Resp> GrpcServerRequest<Req,Resp> newInstance(io.vertx.grpc.server.GrpcServerRequest arg, TypeArg<Req> __typeArg_Req, TypeArg<Resp> __typeArg_Resp) {
    return arg != null ? new GrpcServerRequest<Req,Resp>(arg, __typeArg_Req, __typeArg_Resp) : null;
  }

}
