/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.grpc.server;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A gRPC server based on Vert.x HTTP server.
 *
 * <p> The server can be used as a {@link io.vertx.rxjava3.core.http.HttpServer} handler or mounted as a Vert.x Web handler.
 *
 * <p> Unlike traditional gRPC servers, this server does not rely on a generated RPC interface to interact with the service.
 *
 * Instead, you can interact with the service with a request/response interfaces and gRPC messages, very much like
 * a traditional client.
 *
 * The server exposes 2 levels of handlers
 *
 * <ul>
 *   <li>a Protobuf message {@link io.vertx.rxjava3.grpc.server.GrpcServer #callHandler(Handler) handler}: {@link io.vertx.rxjava3.grpc.server.GrpcServerRequest}/{@link io.vertx.rxjava3.grpc.server.GrpcServerResponse} with Protobuf message that handles any method call in a generic way</li>
 *   <li>a gRPC message {@link io.vertx.rxjava3.grpc.server.GrpcServer #callHandler(MethodDescriptor, Handler) handler}: {@link io.vertx.rxjava3.grpc.server.GrpcServerRequest}/{@link io.vertx.rxjava3.grpc.server.GrpcServerRequest} with gRPC messages that handles specific service method calls</li>
 * </ul>
 *
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpc.server.GrpcServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpc.server.GrpcServer.class)
public class GrpcServer implements RxDelegate, Handler<io.vertx.rxjava3.core.http.HttpServerRequest> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcServer that = (GrpcServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcServer> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcServer((io.vertx.grpc.server.GrpcServer) obj),
    GrpcServer::getDelegate
  );

  private final io.vertx.grpc.server.GrpcServer delegate;
  
  public GrpcServer(io.vertx.grpc.server.GrpcServer delegate) {
    this.delegate = delegate;
  }

  public GrpcServer(Object delegate) {
    this.delegate = (io.vertx.grpc.server.GrpcServer)delegate;
  }

  @Override 
  public io.vertx.grpc.server.GrpcServer getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.core.http.HttpServerRequest event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a blank gRPC server
   * @param vertx the vertx instance
   * @return the created server
   */
  public static io.vertx.rxjava3.grpc.server.GrpcServer server(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.grpc.server.GrpcServer ret = io.vertx.rxjava3.grpc.server.GrpcServer.newInstance((io.vertx.grpc.server.GrpcServer)io.vertx.grpc.server.GrpcServer.server(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a blank gRPC server
   * @param vertx the vertx instance
   * @param options the server options
   * @return the created server
   */
  public static io.vertx.rxjava3.grpc.server.GrpcServer server(io.vertx.rxjava3.core.Vertx vertx, io.vertx.grpc.server.GrpcServerOptions options) { 
    io.vertx.rxjava3.grpc.server.GrpcServer ret = io.vertx.rxjava3.grpc.server.GrpcServer.newInstance((io.vertx.grpc.server.GrpcServer)io.vertx.grpc.server.GrpcServer.server(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Set a call handler that handles any call made to the server.
   * @param handler the service method call handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.grpc.server.GrpcServer callHandler(io.vertx.core.Handler<io.vertx.rxjava3.grpc.server.GrpcServerRequest<io.vertx.rxjava3.core.buffer.Buffer,io.vertx.rxjava3.core.buffer.Buffer>> handler) { 
    delegate.callHandler(io.vertx.lang.rxjava3.Helper.convertHandler(handler, event -> io.vertx.rxjava3.grpc.server.GrpcServerRequest.newInstance((io.vertx.grpc.server.GrpcServerRequest)event, new TypeArg<io.vertx.rxjava3.core.buffer.Buffer>(o0 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o0), o0 -> o0.getDelegate()), new TypeArg<io.vertx.rxjava3.core.buffer.Buffer>(o0 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o0), o0 -> o0.getDelegate()))));
    return this;
  }

  /**
   * Set a service method call handler that handles any call made to the server for the <code>fullMethodName</code> service method.
   * @param serviceMethod the service method
   * @param handler the service method call handler
   * @return a reference to this, so the API can be used fluently
   */
  public <Req, Resp> io.vertx.rxjava3.grpc.server.GrpcServer callHandler(io.vertx.rxjava3.grpc.common.ServiceMethod<Req,Resp> serviceMethod, io.vertx.core.Handler<io.vertx.rxjava3.grpc.server.GrpcServerRequest<Req,Resp>> handler) { 
    io.vertx.rxjava3.grpc.server.GrpcServer ret = io.vertx.rxjava3.grpc.server.GrpcServer.newInstance((io.vertx.grpc.server.GrpcServer)delegate.callHandler(serviceMethod.getDelegate(), io.vertx.lang.rxjava3.Helper.convertHandler(handler, event -> io.vertx.rxjava3.grpc.server.GrpcServerRequest.newInstance((io.vertx.grpc.server.GrpcServerRequest)event, serviceMethod.__typeArg_0, serviceMethod.__typeArg_1))));
    return ret;
  }

  /**
   * @param methodDesc 
   * @param handler 
   * @return 
   */
  @Deprecated()
  public <Req, Resp> io.vertx.rxjava3.grpc.server.GrpcServer callHandler(io.grpc.MethodDescriptor<Req,Resp> methodDesc, io.vertx.core.Handler<io.vertx.rxjava3.grpc.server.GrpcServerRequest<Req,Resp>> handler) { 
    io.vertx.rxjava3.grpc.server.GrpcServer ret = io.vertx.rxjava3.grpc.server.GrpcServer.newInstance((io.vertx.grpc.server.GrpcServer)delegate.callHandler(methodDesc, io.vertx.lang.rxjava3.Helper.convertHandler(handler, event -> io.vertx.rxjava3.grpc.server.GrpcServerRequest.newInstance((io.vertx.grpc.server.GrpcServerRequest)event, TypeArg.unknown(), TypeArg.unknown()))));
    return ret;
  }

  public static GrpcServer newInstance(io.vertx.grpc.server.GrpcServer arg) {
    return arg != null ? new GrpcServer(arg) : null;
  }

}
