/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler.graphql;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler for GraphiQL resources.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.GraphiQLHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.GraphiQLHandler.class)
public class GraphiQLHandler implements RxDelegate, Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GraphiQLHandler that = (GraphiQLHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GraphiQLHandler> __TYPE_ARG = new TypeArg<>(    obj -> new GraphiQLHandler((io.vertx.ext.web.handler.graphql.GraphiQLHandler) obj),
    GraphiQLHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.GraphiQLHandler delegate;
  
  public GraphiQLHandler(io.vertx.ext.web.handler.graphql.GraphiQLHandler delegate) {
    this.delegate = delegate;
  }

  public GraphiQLHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.GraphiQLHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.graphql.GraphiQLHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a new {@link io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandlerBuilder} with default {@link io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions}.
   * @param vertx 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandlerBuilder builder(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandlerBuilder ret = io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandlerBuilder.newInstance((io.vertx.ext.web.handler.graphql.GraphiQLHandlerBuilder)io.vertx.ext.web.handler.graphql.GraphiQLHandler.builder(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler}.
   * <p>
   * The handler will be configured with default {@link io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions}.
   * @param vertx 
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler create(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler ret = io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler.newInstance((io.vertx.ext.web.handler.graphql.GraphiQLHandler)io.vertx.ext.web.handler.graphql.GraphiQLHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler}.
   * <p>
   * The handler will be configured with default {@link io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions}.
   * @return 
   */
  @Deprecated()
  public static io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler create() { 
    io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler ret = io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler.newInstance((io.vertx.ext.web.handler.graphql.GraphiQLHandler)io.vertx.ext.web.handler.graphql.GraphiQLHandler.create());
    return ret;
  }

  /**
   * Create a new {@link io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler}.
   * <p>
   * The handler will be configured with the given <code>options</code>.
   * @param vertx 
   * @param options options for configuring the {@link io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler}
   * @return 
   */
  public static io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions options) { 
    io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler ret = io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler.newInstance((io.vertx.ext.web.handler.graphql.GraphiQLHandler)io.vertx.ext.web.handler.graphql.GraphiQLHandler.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler}.
   * <p>
   * The handler will be configured with the given <code>options</code>.
   * @param options options for configuring the {@link io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler}
   * @return 
   */
  @Deprecated()
  public static io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler create(io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions options) { 
    io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler ret = io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler.newInstance((io.vertx.ext.web.handler.graphql.GraphiQLHandler)io.vertx.ext.web.handler.graphql.GraphiQLHandler.create(options));
    return ret;
  }

  /**
   * Creates a router configured to serve GraphiQL resources.
   * @return a router to be mounted on an existing {@link io.vertx.rxjava3.ext.web.Route}
   */
  public io.vertx.rxjava3.ext.web.Router router() { 
    io.vertx.rxjava3.ext.web.Router ret = io.vertx.rxjava3.ext.web.Router.newInstance((io.vertx.ext.web.Router)delegate.router());
    return ret;
  }

  /**
   * Customize the HTTP headers to add to GraphQL requests sent by the GraphiQL user interface.
   * The result will be applied on top of the fixed set of headers specified in {@link io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions}.
   * <p>
   * This can be useful if, for example, the server is protected by authentication.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.handler.graphql.GraphiQLHandler graphiQLRequestHeaders(java.util.function.Function<io.vertx.rxjava3.ext.web.RoutingContext,io.vertx.rxjava3.core.MultiMap> factory) { 
    delegate.graphiQLRequestHeaders(new Function<io.vertx.ext.web.RoutingContext,io.vertx.core.MultiMap>() {
      public io.vertx.core.MultiMap apply(io.vertx.ext.web.RoutingContext arg) {
        io.vertx.rxjava3.core.MultiMap ret = factory.apply(io.vertx.rxjava3.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret.getDelegate();
      }
    });
    return this;
  }

  public static GraphiQLHandler newInstance(io.vertx.ext.web.handler.graphql.GraphiQLHandler arg) {
    return arg != null ? new GraphiQLHandler(arg) : null;
  }

}
