/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler.graphql;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A message received over Apollo's <code>subscriptions-transport-ws</code> transport.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ApolloWSMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.ApolloWSMessage.class)
@Deprecated()
public class ApolloWSMessage implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApolloWSMessage that = (ApolloWSMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ApolloWSMessage> __TYPE_ARG = new TypeArg<>(    obj -> new ApolloWSMessage((io.vertx.ext.web.handler.graphql.ApolloWSMessage) obj),
    ApolloWSMessage::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ApolloWSMessage delegate;
  
  public ApolloWSMessage(io.vertx.ext.web.handler.graphql.ApolloWSMessage delegate) {
    this.delegate = delegate;
  }

  public ApolloWSMessage(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.ApolloWSMessage)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.graphql.ApolloWSMessage getDelegate() {
    return delegate;
  }

  /**
   * @return the websocket that received the message
   */
  @Deprecated()
  public io.vertx.rxjava3.core.http.ServerWebSocket serverWebSocket() { 
    io.vertx.rxjava3.core.http.ServerWebSocket ret = io.vertx.rxjava3.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)delegate.serverWebSocket());
    return ret;
  }

  /**
   * @return the message type
   */
  @Deprecated()
  public io.vertx.ext.web.handler.graphql.ApolloWSMessageType type() { 
    io.vertx.ext.web.handler.graphql.ApolloWSMessageType ret = delegate.type();
    return ret;
  }

  /**
   * @return the message content
   */
  @Deprecated()
  public io.vertx.core.json.JsonObject content() { 
    io.vertx.core.json.JsonObject ret = delegate.content();
    return ret;
  }

  /**
   * @return the connection params
   */
  @Deprecated()
  public java.lang.Object connectionParams() { 
    java.lang.Object ret = (Object) delegate.connectionParams();
    return ret;
  }

  public static ApolloWSMessage newInstance(io.vertx.ext.web.handler.graphql.ApolloWSMessage arg) {
    return arg != null ? new ApolloWSMessage(arg) : null;
  }

}
