/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An auth handler that provides FIDO2 WebAuthN Relay Party support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.WebAuthnHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.WebAuthnHandler.class)
public class WebAuthnHandler implements RxDelegate, io.vertx.rxjava3.ext.web.handler.AuthenticationHandler, Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebAuthnHandler that = (WebAuthnHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WebAuthnHandler> __TYPE_ARG = new TypeArg<>(    obj -> new WebAuthnHandler((io.vertx.ext.web.handler.WebAuthnHandler) obj),
    WebAuthnHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.WebAuthnHandler delegate;
  
  public WebAuthnHandler(io.vertx.ext.web.handler.WebAuthnHandler delegate) {
    this.delegate = delegate;
  }

  public WebAuthnHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.WebAuthnHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.WebAuthnHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a WebAuthN auth handler. This handler expects at least the response callback to be installed.
   * @param webAuthn 
   * @return the auth handler
   */
  public static io.vertx.rxjava3.ext.web.handler.WebAuthnHandler create(io.vertx.rxjava3.ext.auth.webauthn.WebAuthn webAuthn) { 
    io.vertx.rxjava3.ext.web.handler.WebAuthnHandler ret = io.vertx.rxjava3.ext.web.handler.WebAuthnHandler.newInstance((io.vertx.ext.web.handler.WebAuthnHandler)io.vertx.ext.web.handler.WebAuthnHandler.create(webAuthn.getDelegate()));
    return ret;
  }

  /**
   * The callback route to create registration attestations. Usually this route is <pre>/webauthn/register</pre>
   * @param route the route where credential get options are generated.
   * @return fluent self.
   */
  public io.vertx.rxjava3.ext.web.handler.WebAuthnHandler setupCredentialsCreateCallback(io.vertx.rxjava3.ext.web.Route route) { 
    delegate.setupCredentialsCreateCallback(route.getDelegate());
    return this;
  }

  /**
   * The callback route to create login attestations. Usually this route is <pre>/webauthn/login</pre>
   * @param route the route where credential get options are generated.
   * @return fluent self.
   */
  public io.vertx.rxjava3.ext.web.handler.WebAuthnHandler setupCredentialsGetCallback(io.vertx.rxjava3.ext.web.Route route) { 
    delegate.setupCredentialsGetCallback(route.getDelegate());
    return this;
  }

  /**
   * The callback route to verify attestations and assertions. Usually this route is <pre>/webauthn/response</pre>
   * @param route the route where assertions and attestations are verified.
   * @return fluent self.
   */
  public io.vertx.rxjava3.ext.web.handler.WebAuthnHandler setupCallback(io.vertx.rxjava3.ext.web.Route route) { 
    delegate.setupCallback(route.getDelegate());
    return this;
  }

  /**
   * Set the Origin to be validated by the webauthn object.
   * @param origin - an HTTP Origin
   * @return fluent self
   */
  public io.vertx.rxjava3.ext.web.handler.WebAuthnHandler setOrigin(java.lang.String origin) { 
    delegate.setOrigin(origin);
    return this;
  }

  public static WebAuthnHandler newInstance(io.vertx.ext.web.handler.WebAuthnHandler arg) {
    return arg != null ? new WebAuthnHandler(arg) : null;
  }

}
