/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.api.validation;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An interface for add HTTP Request validation. This class can validate parameters inside query, path, headers an
 * body (watch below)
 * <br/>
 * You can assign multiple body type at the same time(for example a JSON schema together with a XML schema). This
 * interface support:
 * <ul>
 * <li>application/x-www-form-urlencoded</li>
 * <li>multipart/form-data</li>
 * <li>application/xml</li>
 * <li>application/json</li>
 * </ul>
 * Also you can add a form parameter for validation without care about content type of your request. For form
 * parameters this interface support both "multipart/form-data" and "application/x-www-form-urlencoded"
 * <br/>
 * This interface allow extra parameters in the request, so it doesn't care if in a request there's a parameter
 * without a specified validation rule
 * <br/>
 * If a parameter is flagged as an array, it will be validated also if the size of array is 1 element
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.validation.HTTPRequestValidationHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.api.validation.HTTPRequestValidationHandler.class)
@Deprecated()
public class HTTPRequestValidationHandler implements RxDelegate, io.vertx.rxjava3.ext.web.api.validation.ValidationHandler, Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPRequestValidationHandler that = (HTTPRequestValidationHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HTTPRequestValidationHandler> __TYPE_ARG = new TypeArg<>(    obj -> new HTTPRequestValidationHandler((io.vertx.ext.web.api.validation.HTTPRequestValidationHandler) obj),
    HTTPRequestValidationHandler::getDelegate
  );

  private final io.vertx.ext.web.api.validation.HTTPRequestValidationHandler delegate;
  
  public HTTPRequestValidationHandler(io.vertx.ext.web.api.validation.HTTPRequestValidationHandler delegate) {
    this.delegate = delegate;
  }

  public HTTPRequestValidationHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.validation.HTTPRequestValidationHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.api.validation.HTTPRequestValidationHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  @Deprecated()
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Factory method to create an HTTPRequestValidationHandler
   * @return new HTTPRequestValidationHandler
   */
  @Deprecated()
  public static io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler create() { 
    io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler ret = io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler.newInstance((io.vertx.ext.web.api.validation.HTTPRequestValidationHandler)io.vertx.ext.web.api.validation.HTTPRequestValidationHandler.create());
    return ret;
  }

  /**
   * Add a path parameter with included parameter types. All path params are <b>required</b>
   * @param parameterName expected name of parameter inside the path
   * @param type expected type of parameter
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addPathParam(java.lang.String parameterName, io.vertx.ext.web.api.validation.ParameterType type) { 
    delegate.addPathParam(parameterName, type);
    return this;
  }

  /**
   * Add a path parameter with a custom pattern. All path params are <b>required</b>
   * @param parameterName expected name of parameter inside the path
   * @param pattern regular expression for validation
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addPathParamWithPattern(java.lang.String parameterName, java.lang.String pattern) { 
    delegate.addPathParamWithPattern(parameterName, pattern);
    return this;
  }

  /**
   * Add a path parameter with a custom type validator. All path params are <b>required</b>. For more informations
   * about how to construct built-in or custom type validator, check out {@link io.vertx.rxjava3.ext.web.api.validation.ParameterTypeValidator}
   * @param parameterName expected name of parameter inside the path
   * @param validator type validator
   * @param allowEmptyValue true if parameter allowEmptyValue. For more informations about allowEmptyValue behaviour: {@link io.vertx.rxjava3.ext.web.api.validation.ParameterValidationRule#allowEmptyValue}
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addPathParamWithCustomTypeValidator(java.lang.String parameterName, io.vertx.rxjava3.ext.web.api.validation.ParameterTypeValidator validator, boolean allowEmptyValue) { 
    delegate.addPathParamWithCustomTypeValidator(parameterName, validator.getDelegate(), allowEmptyValue);
    return this;
  }

  /**
   * Add a query parameter with included parameter types
   * @param parameterName expected name of parameter inside the query
   * @param type expected type of parameter
   * @param required true if parameter is required
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addQueryParam(java.lang.String parameterName, io.vertx.ext.web.api.validation.ParameterType type, boolean required) { 
    delegate.addQueryParam(parameterName, type, required);
    return this;
  }

  /**
   * Add a query parameter with a custom pattern
   * @param parameterName expected name of parameter inside the query
   * @param pattern regular expression for validation
   * @param required true if parameter is required
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addQueryParamWithPattern(java.lang.String parameterName, java.lang.String pattern, boolean required) { 
    delegate.addQueryParamWithPattern(parameterName, pattern, required);
    return this;
  }

  /**
   * Add a query parameters array with included parameter types
   * @param arrayName expected name of array inside the query
   * @param type expected type of parameter
   * @param required true if parameter is required
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addQueryParamsArray(java.lang.String arrayName, io.vertx.ext.web.api.validation.ParameterType type, boolean required) { 
    delegate.addQueryParamsArray(arrayName, type, required);
    return this;
  }

  /**
   * Add a query parameters array with a custom pattern
   * @param arrayName expected name of array inside the query
   * @param pattern regular expression for validation
   * @param required true if parameter is required
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addQueryParamsArrayWithPattern(java.lang.String arrayName, java.lang.String pattern, boolean required) { 
    delegate.addQueryParamsArrayWithPattern(arrayName, pattern, required);
    return this;
  }

  /**
   * Add a query parameter with a custom type validator. For more informations about how to construct built-in or
   * custom type validator, check out {@link io.vertx.rxjava3.ext.web.api.validation.ParameterTypeValidator}
   * @param parameterName expected name of parameter inside the query
   * @param validator type validator
   * @param required true if parameter is required
   * @param allowEmptyValue true if parameter allowEmptyValue. For more informations about allowEmptyValue behaviour: {@link io.vertx.rxjava3.ext.web.api.validation.ParameterValidationRule#allowEmptyValue}
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addQueryParamWithCustomTypeValidator(java.lang.String parameterName, io.vertx.rxjava3.ext.web.api.validation.ParameterTypeValidator validator, boolean required, boolean allowEmptyValue) { 
    delegate.addQueryParamWithCustomTypeValidator(parameterName, validator.getDelegate(), required, allowEmptyValue);
    return this;
  }

  /**
   * Add a header parameter with included parameter types
   * @param headerName expected header name
   * @param type expected type of parameter
   * @param required true if parameter is required
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addHeaderParam(java.lang.String headerName, io.vertx.ext.web.api.validation.ParameterType type, boolean required) { 
    delegate.addHeaderParam(headerName, type, required);
    return this;
  }

  /**
   * Add a header parameter with a custom pattern
   * @param headerName expected header name
   * @param pattern regular expression for validation
   * @param required true if parameter is required
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addHeaderParamWithPattern(java.lang.String headerName, java.lang.String pattern, boolean required) { 
    delegate.addHeaderParamWithPattern(headerName, pattern, required);
    return this;
  }

  /**
   * Add a header parameter with a custom type validator. For more informations about how to construct built-in or
   * custom type validator, check out {@link io.vertx.rxjava3.ext.web.api.validation.ParameterTypeValidator}
   * @param headerName expected header namery
   * @param validator type validator
   * @param required true if parameter is required
   * @param allowEmptyValue true if parameter allowEmptyValue. For more informations about allowEmptyValue behaviour: {@link io.vertx.rxjava3.ext.web.api.validation.ParameterValidationRule#allowEmptyValue}
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addHeaderParamWithCustomTypeValidator(java.lang.String headerName, io.vertx.rxjava3.ext.web.api.validation.ParameterTypeValidator validator, boolean required, boolean allowEmptyValue) { 
    delegate.addHeaderParamWithCustomTypeValidator(headerName, validator.getDelegate(), required, allowEmptyValue);
    return this;
  }

  /**
   * Add a single parameter inside a form with included parameter types
   * @param parameterName expected name of parameter inside the form
   * @param type expected type of parameter
   * @param required true if parameter is required
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addFormParam(java.lang.String parameterName, io.vertx.ext.web.api.validation.ParameterType type, boolean required) { 
    delegate.addFormParam(parameterName, type, required);
    return this;
  }

  /**
   * Add a single parameter inside a form with a custom pattern
   * @param parameterName expected name of parameter inside the form
   * @param pattern regular expression for validation
   * @param required true if parameter is required
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addFormParamWithPattern(java.lang.String parameterName, java.lang.String pattern, boolean required) { 
    delegate.addFormParamWithPattern(parameterName, pattern, required);
    return this;
  }

  /**
   * Add a form parameters array with included parameter types
   * @param parameterName expected name of array of parameters inside the form
   * @param type expected type of array of parameters
   * @param required true if parameter is required
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addFormParamsArray(java.lang.String parameterName, io.vertx.ext.web.api.validation.ParameterType type, boolean required) { 
    delegate.addFormParamsArray(parameterName, type, required);
    return this;
  }

  /**
   * Add a form parameters array with a custom pattern
   * @param parameterName expected name of array of parameters inside the form
   * @param pattern regular expression for validation
   * @param required true if parameter is required
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addFormParamsArrayWithPattern(java.lang.String parameterName, java.lang.String pattern, boolean required) { 
    delegate.addFormParamsArrayWithPattern(parameterName, pattern, required);
    return this;
  }

  /**
   * Add a form parameter with a custom type validator. For more informations about how to construct built-in or
   * custom type validator, check out {@link io.vertx.rxjava3.ext.web.api.validation.ParameterTypeValidator}
   * @param parameterName expected name of parameter inside the form
   * @param validator type validator
   * @param required true if parameter is required
   * @param allowEmptyValue true if parameter allowEmptyValue. For more informations about allowEmptyValue behaviour: {@link io.vertx.rxjava3.ext.web.api.validation.ParameterValidationRule#allowEmptyValue}
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addFormParamWithCustomTypeValidator(java.lang.String parameterName, io.vertx.rxjava3.ext.web.api.validation.ParameterTypeValidator validator, boolean required, boolean allowEmptyValue) { 
    delegate.addFormParamWithCustomTypeValidator(parameterName, validator.getDelegate(), required, allowEmptyValue);
    return this;
  }

  /**
   * Add a custom validator. For more informations about custom validator, see {@link io.vertx.rxjava3.ext.web.api.validation.CustomValidator}
   * @param customValidator 
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addCustomValidatorFunction(io.vertx.rxjava3.ext.web.api.validation.CustomValidator customValidator) { 
    delegate.addCustomValidatorFunction(customValidator.getDelegate());
    return this;
  }

  /**
   * Add a json schema for body with Content-Type "application/json"
   * @param jsonSchema 
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addJsonBodySchema(java.lang.String jsonSchema) { 
    delegate.addJsonBodySchema(jsonSchema);
    return this;
  }

  /**
   * Add a xml schema for body with Content-Type "application/xml"
   * @param xmlSchema 
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addXMLBodySchema(java.lang.String xmlSchema) { 
    delegate.addXMLBodySchema(xmlSchema);
    return this;
  }

  /**
   * Add an expected filename inside <b>multipart request</b>.
   * @param filename name of the file inside the form
   * @param contentType expected content type of file
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addMultipartRequiredFile(java.lang.String filename, java.lang.String contentType) { 
    delegate.addMultipartRequiredFile(filename, contentType);
    return this;
  }

  /**
   * Add an expected content type of request. It's not needed to add application/json, application/xml,
   * multipart/form-data and application/x-www-form-urlencoded
   * @param contentType expected content type of file
   * @return this handler
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.api.validation.HTTPRequestValidationHandler addExpectedContentType(java.lang.String contentType) { 
    delegate.addExpectedContentType(contentType);
    return this;
  }

  public static HTTPRequestValidationHandler newInstance(io.vertx.ext.web.api.validation.HTTPRequestValidationHandler arg) {
    return arg != null ? new HTTPRequestValidationHandler(arg) : null;
  }

}
