/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.shell.system;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A process managed by the shell.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.system.Process original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.system.Process.class)
public class Process implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Process that = (Process) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Process> __TYPE_ARG = new TypeArg<>(    obj -> new Process((io.vertx.ext.shell.system.Process) obj),
    Process::getDelegate
  );

  private final io.vertx.ext.shell.system.Process delegate;
  
  public Process(io.vertx.ext.shell.system.Process delegate) {
    this.delegate = delegate;
  }

  public Process(Object delegate) {
    this.delegate = (io.vertx.ext.shell.system.Process)delegate;
  }

  @Override 
  public io.vertx.ext.shell.system.Process getDelegate() {
    return delegate;
  }

  /**
   * @return the current process status
   */
  public io.vertx.ext.shell.system.ExecStatus status() { 
    io.vertx.ext.shell.system.ExecStatus ret = delegate.status();
    return ret;
  }

  /**
   * @return the process exit code when the status is  otherwise <code>null</code>
   */
  public java.lang.Integer exitCode() { 
    java.lang.Integer ret = delegate.exitCode();
    return ret;
  }

  /**
   * Set the process tty.
   * @param tty the process tty
   * @return this object
   */
  public io.vertx.rxjava3.ext.shell.system.Process setTty(io.vertx.rxjava3.ext.shell.term.Tty tty) { 
    delegate.setTty(tty.getDelegate());
    return this;
  }

  /**
   * @return the process tty
   */
  public io.vertx.rxjava3.ext.shell.term.Tty getTty() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava3.ext.shell.term.Tty ret = io.vertx.rxjava3.ext.shell.term.Tty.newInstance((io.vertx.ext.shell.term.Tty)delegate.getTty());
    cached_0 = ret;
    return ret;
  }

  /**
   * Set the process session
   * @param session the process session
   * @return this object
   */
  public io.vertx.rxjava3.ext.shell.system.Process setSession(io.vertx.rxjava3.ext.shell.session.Session session) { 
    delegate.setSession(session.getDelegate());
    return this;
  }

  /**
   * @return the process session
   */
  public io.vertx.rxjava3.ext.shell.session.Session getSession() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.rxjava3.ext.shell.session.Session ret = io.vertx.rxjava3.ext.shell.session.Session.newInstance((io.vertx.ext.shell.session.Session)delegate.getSession());
    cached_1 = ret;
    return ret;
  }

  /**
   * Set an handler for being notified when the process terminates.
   * @param handler the handler called when the process terminates.
   * @return this object
   */
  public io.vertx.rxjava3.ext.shell.system.Process terminatedHandler(io.vertx.core.Handler<java.lang.Integer> handler) { 
    delegate.terminatedHandler(handler);
    return this;
  }

  /**
   * Run the process.
   *
   */
  public void run() { 
    delegate.run();
  }

  /**
   * Run the process.
   *
   * @param foregraound 
   */
  public void run(boolean foregraound) { 
    delegate.run(foregraound);
  }

  /**
   * Attempt to interrupt the process.
   * @return true if the process caught the signal
   */
  public boolean interrupt() { 
    boolean ret = delegate.interrupt();
    return ret;
  }

  /**
   * Attempt to interrupt the process.
   * @param completionHandler handler called after interrupt callback
   * @return true if the process caught the signal
   */
  public boolean interrupt(io.vertx.core.Handler<java.lang.Void> completionHandler) { 
    boolean ret = delegate.interrupt(completionHandler);
    return ret;
  }

  /**
   * Suspend the process.
   */
  public void resume() { 
    delegate.resume();
  }

  /**
   * Suspend the process.
   * @param foreground 
   */
  public void resume(boolean foreground) { 
    delegate.resume(foreground);
  }

  /**
   * Suspend the process.
   * @param completionHandler handler called after resume callback
   */
  public void resume(io.vertx.core.Handler<java.lang.Void> completionHandler) { 
    delegate.resume(completionHandler);
  }

  /**
   * Suspend the process.
   * @param foreground 
   * @param completionHandler handler called after resume callback
   */
  public void resume(boolean foreground, io.vertx.core.Handler<java.lang.Void> completionHandler) { 
    delegate.resume(foreground, completionHandler);
  }

  /**
   * Resume the process.
   */
  public void suspend() { 
    delegate.suspend();
  }

  /**
   * Resume the process.
   * @param completionHandler handler called after suspend callback
   */
  public void suspend(io.vertx.core.Handler<java.lang.Void> completionHandler) { 
    delegate.suspend(completionHandler);
  }

  /**
   * Terminate the process.
   */
  public void terminate() { 
    delegate.terminate();
  }

  /**
   * Terminate the process.
   * @param completionHandler handler called after end callback
   */
  public void terminate(io.vertx.core.Handler<java.lang.Void> completionHandler) { 
    delegate.terminate(completionHandler);
  }

  /**
   * Set the process in background.
   */
  public void toBackground() { 
    delegate.toBackground();
  }

  /**
   * Set the process in background.
   * @param completionHandler handler called after background callback
   */
  public void toBackground(io.vertx.core.Handler<java.lang.Void> completionHandler) { 
    delegate.toBackground(completionHandler);
  }

  /**
   * Set the process in foreground.
   */
  public void toForeground() { 
    delegate.toForeground();
  }

  /**
   * Set the process in foreground.
   * @param completionHandler handler called after foreground callback
   */
  public void toForeground(io.vertx.core.Handler<java.lang.Void> completionHandler) { 
    delegate.toForeground(completionHandler);
  }

  private io.vertx.rxjava3.ext.shell.term.Tty cached_0;
  private io.vertx.rxjava3.ext.shell.session.Session cached_1;
  public static Process newInstance(io.vertx.ext.shell.system.Process arg) {
    return arg != null ? new Process(arg) : null;
  }

}
