/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.shell.system;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The job controller.<p/>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.system.JobController original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.system.JobController.class)
public class JobController implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JobController that = (JobController) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JobController> __TYPE_ARG = new TypeArg<>(    obj -> new JobController((io.vertx.ext.shell.system.JobController) obj),
    JobController::getDelegate
  );

  private final io.vertx.ext.shell.system.JobController delegate;
  
  public JobController(io.vertx.ext.shell.system.JobController delegate) {
    this.delegate = delegate;
  }

  public JobController(Object delegate) {
    this.delegate = (io.vertx.ext.shell.system.JobController)delegate;
  }

  @Override 
  public io.vertx.ext.shell.system.JobController getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.ext.shell.system.Job> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.ext.shell.system.Job>(o1 -> io.vertx.rxjava3.ext.shell.system.Job.newInstance((io.vertx.ext.shell.system.Job)o1), o1 -> o1.getDelegate());

  /**
   * @return the current foreground job
   */
  public io.vertx.rxjava3.ext.shell.system.Job foregroundJob() { 
    io.vertx.rxjava3.ext.shell.system.Job ret = io.vertx.rxjava3.ext.shell.system.Job.newInstance((io.vertx.ext.shell.system.Job)delegate.foregroundJob());
    return ret;
  }

  /**
   * @return the active jobs
   */
  public java.util.Set<io.vertx.rxjava3.ext.shell.system.Job> jobs() { 
    java.util.Set<io.vertx.rxjava3.ext.shell.system.Job> ret = delegate.jobs().stream().map(elt -> io.vertx.rxjava3.ext.shell.system.Job.newInstance((io.vertx.ext.shell.system.Job)elt)).collect(Collectors.toSet());
    return ret;
  }

  /**
   * Returns an active job in this session by its .
   * @param id the job id
   * @return the job of  when not found
   */
  public io.vertx.rxjava3.ext.shell.system.Job getJob(int id) { 
    io.vertx.rxjava3.ext.shell.system.Job ret = io.vertx.rxjava3.ext.shell.system.Job.newInstance((io.vertx.ext.shell.system.Job)delegate.getJob(id));
    return ret;
  }

  /**
   * Create a job wrapping a process.
   * @param process the process
   * @param line the line
   * @return the created job
   */
  public io.vertx.rxjava3.ext.shell.system.Job createJob(io.vertx.rxjava3.ext.shell.system.Process process, java.lang.String line) { 
    io.vertx.rxjava3.ext.shell.system.Job ret = io.vertx.rxjava3.ext.shell.system.Job.newInstance((io.vertx.ext.shell.system.Job)delegate.createJob(process.getDelegate(), line));
    return ret;
  }

  /**
   * Close the controller and terminate all the underlying jobs, a closed controller does not accept anymore jobs.
   * @param completionHandler 
   */
  public void close(io.vertx.core.Handler<java.lang.Void> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Close the shell session and terminate all the underlying jobs.
   */
  public void close() { 
    delegate.close();
  }

  public static JobController newInstance(io.vertx.ext.shell.system.JobController arg) {
    return arg != null ? new JobController(arg) : null;
  }

}
