/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.http;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous WebSocket client.
 * <p>
 * It allows you to open WebSockets to servers.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.WebSocketClient.class)
public class WebSocketClient implements RxDelegate, io.vertx.rxjava3.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebSocketClient that = (WebSocketClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WebSocketClient> __TYPE_ARG = new TypeArg<>(    obj -> new WebSocketClient((io.vertx.core.http.WebSocketClient) obj),
    WebSocketClient::getDelegate
  );

  private final io.vertx.core.http.WebSocketClient delegate;
  
  public WebSocketClient(io.vertx.core.http.WebSocketClient delegate) {
    this.delegate = delegate;
  }

  public WebSocketClient(Object delegate) {
    this.delegate = (io.vertx.core.http.WebSocketClient)delegate;
  }

  @Override 
  public io.vertx.core.http.WebSocketClient getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Create a WebSocket that is not yet connected to the server.
   * @return the client WebSocket
   */
  public io.vertx.rxjava3.core.http.ClientWebSocket webSocket() { 
    io.vertx.rxjava3.core.http.ClientWebSocket ret = io.vertx.rxjava3.core.http.ClientWebSocket.newInstance((io.vertx.core.http.ClientWebSocket)delegate.webSocket());
    return ret;
  }

  /**
   * Connect a WebSocket to the specified port, host and relative request URI
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> connect(int port, java.lang.String host, java.lang.String requestURI) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> ret = rxConnect(port, host, requestURI);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Connect a WebSocket to the specified port, host and relative request URI
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> rxConnect(int port, java.lang.String host, java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.connect(port, host, requestURI, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)event))));
    });
  }

  /**
   * Connect a WebSocket to the default client port and specified host and relative request URI.
   * @param host the host
   * @param requestURI the relative URI
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> connect(java.lang.String host, java.lang.String requestURI) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> ret = rxConnect(host, requestURI);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Connect a WebSocket to the default client port and specified host and relative request URI.
   * @param host the host
   * @param requestURI the relative URI
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> rxConnect(java.lang.String host, java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.connect(host, requestURI, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)event))));
    });
  }

  /**
   * Connect a WebSocket to the default client port, default client host and specified, relative request URI.
   * @param requestURI the relative URI
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> connect(java.lang.String requestURI) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> ret = rxConnect(requestURI);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Connect a WebSocket to the default client port, default client host and specified, relative request URI.
   * @param requestURI the relative URI
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> rxConnect(java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.connect(requestURI, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)event))));
    });
  }

  /**
   * Connect a WebSocket with the specified options.
   * @param options the request options
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> connect(io.vertx.core.http.WebSocketConnectOptions options) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> ret = rxConnect(options);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Connect a WebSocket with the specified options.
   * @param options the request options
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.WebSocket> rxConnect(io.vertx.core.http.WebSocketConnectOptions options) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.connect(options, io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)event))));
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.WebSocketClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.SSLOptions options) { 
    io.reactivex.rxjava3.core.Single<java.lang.Boolean> ret = rxUpdateSSLOptions(options);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.WebSocketClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.SSLOptions options) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.updateSSLOptions(options, handler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.WebSocketClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.SSLOptions options, boolean force) { 
    io.reactivex.rxjava3.core.Single<java.lang.Boolean> ret = rxUpdateSSLOptions(options, force);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.WebSocketClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.SSLOptions options, boolean force) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.updateSSLOptions(options, force, handler);
    });
  }

  /**
   * Close the client. Closing will close down any pooled connections.
   * Clients should always be closed after use.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the client. Closing will close down any pooled connections.
   * Clients should always be closed after use.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.close(handler);
    });
  }

  public static WebSocketClient newInstance(io.vertx.core.http.WebSocketClient arg) {
    return arg != null ? new WebSocketClient(arg) : null;
  }

}
